/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.services;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.rest.api.service.wa.WAClientAppService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.mapping.RegisteredServiceMapper;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class WAServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WAServiceRegistry.class);
    protected final WARestClient waRestClient;
    protected final RegisteredServiceMapper registeredServiceMapper;

    public WAServiceRegistry(WARestClient restClient, RegisteredServiceMapper registeredServiceMapper, ConfigurableApplicationContext applicationContext, Collection<ServiceRegistryListener> serviceRegistryListeners) {
        super(applicationContext, serviceRegistryListeners);
        this.waRestClient = restClient;
        this.registeredServiceMapper = registeredServiceMapper;
    }

    public RegisteredService save(RegisteredService registeredService) {
        throw new UnsupportedOperationException("Saving registered services from WA is not supported");
    }

    public boolean delete(RegisteredService registeredService) {
        throw new UnsupportedOperationException("Deleting registered services from WA is not supported");
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Bulk deleting registered services from WA is not supported");
    }

    public Collection<RegisteredService> load() {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch application definitions");
            return List.of();
        }
        LOG.info("Loading application definitions");
        return ((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).list().stream().map(this.registeredServiceMapper::toRegisteredService).filter(Objects::nonNull).toList();
    }

    public RegisteredService findServiceById(long id) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch application definitions");
            return null;
        }
        LOG.info("Searching for application definition by id {}", (Object)id);
        return this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(Long.valueOf(id), null));
    }

    public <T extends RegisteredService> T findServiceById(long id, Class<T> clazz) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch application definitions");
            return null;
        }
        LOG.info("Searching for application definition by id {} and type {}", (Object)id, clazz);
        if (clazz.isInstance(OidcRegisteredService.class)) {
            return (T)this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(Long.valueOf(id), ClientAppType.OIDCRP));
        }
        if (clazz.isInstance(SamlRegisteredService.class)) {
            return (T)this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(Long.valueOf(id), ClientAppType.SAML2SP));
        }
        return (T)this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(Long.valueOf(id), ClientAppType.CASSP));
    }

    public <T extends RegisteredService> T findServiceByExactServiceName(String name, Class<T> clazz) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch application definitions");
            return null;
        }
        LOG.info("Searching for application definition by name {} and type {}", (Object)name, clazz);
        if (clazz.isInstance(OidcRegisteredService.class)) {
            return (T)this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(name, ClientAppType.OIDCRP));
        }
        if (clazz.isInstance(SamlRegisteredService.class)) {
            return (T)this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(name, ClientAppType.SAML2SP));
        }
        return (T)this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(name, ClientAppType.CASSP));
    }

    public RegisteredService findServiceByExactServiceName(String name) {
        if (!this.waRestClient.isReady()) {
            LOG.debug("Syncope client is not yet ready to fetch application definitions");
            return null;
        }
        LOG.info("Searching for application definition by name {}", (Object)name);
        return this.registeredServiceMapper.toRegisteredService(((WAClientAppService)this.waRestClient.getService(WAClientAppService.class)).read(name, null));
    }
}

