/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.consent.BaseConsentRepository;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class GroovyConsentRepository
extends BaseConsentRepository
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyConsentRepository.class);
    private static final long serialVersionUID = 3482998768083902246L;
    private final ExecutableCompiledScript watchableScript;

    public GroovyConsentRepository(Resource groovyResource) throws Throwable {
        ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        this.watchableScript = scriptFactory.fromResource(groovyResource);
        this.setConsentDecisions(this.readDecisionsFromGroovyResource());
    }

    @Override
    public ConsentDecision storeConsentDecision(ConsentDecision decision) throws Throwable {
        ConsentDecision result = super.storeConsentDecision(decision);
        this.writeAccountToGroovyResource(decision);
        return result;
    }

    @Override
    public boolean deleteConsentDecision(long decisionId, String principal) throws Throwable {
        super.deleteConsentDecision(decisionId, principal);
        return (Boolean)this.watchableScript.execute("delete", Boolean.class, new Object[]{decisionId, principal, LOGGER});
    }

    @Override
    public boolean deleteConsentDecisions(String principal) throws Throwable {
        super.deleteConsentDecisions(principal);
        return (Boolean)this.watchableScript.execute("deletePrincipal", Boolean.class, new Object[]{principal, LOGGER});
    }

    @Override
    public void deleteAll() throws Throwable {
        super.deleteAll();
        this.watchableScript.execute("deleteAll", Void.class, new Object[]{LOGGER});
    }

    public void destroy() {
        this.watchableScript.close();
    }

    private void writeAccountToGroovyResource(ConsentDecision decision) throws Throwable {
        this.watchableScript.execute("write", Boolean.class, new Object[]{decision, LOGGER});
    }

    private Set<ConsentDecision> readDecisionsFromGroovyResource() throws Throwable {
        return (Set)this.watchableScript.execute("read", Set.class, new Object[]{this.getConsentDecisions(), LOGGER});
    }
}

