/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.entity.JobStatus;
import org.apache.syncope.core.persistence.jpa.entity.JPAJobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class JPAJobStatusDAO
implements JobStatusDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(JobStatusDAO.class);
    protected final EntityManager entityManager;

    public JPAJobStatusDAO(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional(readOnly=true)
    public boolean existsById(String key) {
        Query query = this.entityManager.createQuery("SELECT COUNT(e) FROM " + JPAJobStatus.class.getSimpleName() + " e WHERE e.id = :key");
        query.setParameter("key", (Object)key);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }

    @Transactional(readOnly=true)
    public Optional<? extends JobStatus> findById(String key) {
        return Optional.ofNullable((JPAJobStatus)this.entityManager.find(JPAJobStatus.class, (Object)key));
    }

    @Transactional(readOnly=true)
    public long count() {
        Query query = this.entityManager.createQuery("SELECT COUNT(e) FROM " + JPAJobStatus.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).longValue();
    }

    @Transactional(readOnly=true)
    public List<? extends JobStatus> findAll() {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAJobStatus.class.getSimpleName() + " e", JobStatus.class);
        return query.getResultList();
    }

    public <S extends JobStatus> S save(S jobStatus) {
        return (S)((JobStatus)this.entityManager.merge(jobStatus));
    }

    public void delete(JobStatus jobStatus) {
        this.entityManager.remove((Object)jobStatus);
    }

    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }

    public boolean lock(String key) {
        if (this.existsById(key)) {
            return false;
        }
        try {
            JPAJobStatus jobStatus = new JPAJobStatus();
            jobStatus.setKey(key);
            jobStatus.setStatus("JOB_FIRED");
            this.save((JobStatus)jobStatus);
            return true;
        }
        catch (Exception e) {
            LOG.debug("Could not lock job {}", (Object)key, (Object)e);
            return false;
        }
    }

    public void unlock(String key) {
        this.deleteById(key);
    }
}

