/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyTypeRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyType;
import org.springframework.transaction.annotation.Transactional;

public class AnyTypeRepoExtImpl
implements AnyTypeRepoExt {
    protected final RemediationDAO remediationDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final EntityManager entityManager;

    public AnyTypeRepoExtImpl(RemediationDAO remediationDAO, RelationshipTypeDAO relationshipTypeDAO, EntityManager entityManager) {
        this.remediationDAO = remediationDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public AnyType getUser() {
        return (AnyType)this.entityManager.find(JPAAnyType.class, (Object)AnyTypeKind.USER.name());
    }

    @Override
    @Transactional(readOnly=true)
    public AnyType getGroup() {
        return (AnyType)this.entityManager.find(JPAAnyType.class, (Object)AnyTypeKind.GROUP.name());
    }

    @Override
    public void deleteById(String key) {
        AnyType anyType = (AnyType)this.entityManager.find(JPAAnyType.class, (Object)key);
        if (anyType == null) {
            return;
        }
        if (anyType.equals((Object)this.getUser()) || anyType.equals((Object)this.getGroup())) {
            throw new IllegalArgumentException(key + " cannot be deleted");
        }
        this.remediationDAO.findByAnyType(anyType).forEach(remediation -> {
            remediation.setAnyType(null);
            this.remediationDAO.delete((Entity)remediation);
        });
        this.relationshipTypeDAO.findByEndAnyType(anyType).forEach(arg_0 -> ((RelationshipTypeDAO)this.relationshipTypeDAO).deleteById(arg_0));
        this.entityManager.remove((Object)anyType);
    }
}

