/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import org.apache.syncope.common.lib.policy.AuthPolicyConf;
import org.apache.syncope.common.lib.policy.DefaultAuthPolicyConf;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.jpa.dao.repo.AuthModuleRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.am.JPAAuthModule;

public class AuthModuleRepoExtImpl
implements AuthModuleRepoExt {
    protected final PolicyDAO policyDAO;
    protected final EntityManager entityManager;

    public AuthModuleRepoExtImpl(PolicyDAO policyDAO, EntityManager entityManager) {
        this.policyDAO = policyDAO;
        this.entityManager = entityManager;
    }

    @Override
    public AuthModule save(AuthModule authModule) {
        ((JPAAuthModule)authModule).list2json();
        return (AuthModule)this.entityManager.merge((Object)authModule);
    }

    @Override
    public void delete(AuthModule authModule) {
        this.policyDAO.findAll(AuthPolicy.class).stream().filter(policy -> policy.getConf() instanceof DefaultAuthPolicyConf).forEach(policy -> {
            DefaultAuthPolicyConf conf = (DefaultAuthPolicyConf)policy.getConf();
            if (conf.getAuthModules().remove(authModule.getKey())) {
                policy.setConf((AuthPolicyConf)conf);
                this.policyDAO.save((Entity)policy);
            }
        });
        this.entityManager.remove((Object)authModule);
    }
}

