/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.jpa.dao.repo.RemediationRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPARemediation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class RemediationRepoExtImpl
implements RemediationRepoExt {
    protected static final Logger LOG = LoggerFactory.getLogger(RemediationRepoExt.class);
    protected final EntityManager entityManager;

    public RemediationRepoExtImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected StringBuilder query(StringBuilder select, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder query = select.append(JPARemediation.class.getSimpleName()).append(" e WHERE 1=1 ");
        if (before != null) {
            query.append("AND e.instant <= :before ");
        }
        if (after != null) {
            query.append("AND e.instant >= :after ");
        }
        return query;
    }

    @Override
    public long count(OffsetDateTime before, OffsetDateTime after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), before, after);
        Query query = this.entityManager.createQuery(queryString.toString());
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).longValue();
    }

    @Override
    public List<Remediation> findAll(OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), before, after);
        if (!pageable.getSort().isEmpty()) {
            queryString.append(" ORDER BY ");
            pageable.getSort().forEach(clause -> {
                String field = clause.getProperty().trim();
                boolean ack = true;
                if ("resource".equals(field)) {
                    queryString.append("e.pullTask.resource.id");
                } else {
                    Field beanField = ReflectionUtils.findField(JPARemediation.class, (String)field);
                    if (beanField == null) {
                        ack = false;
                        LOG.warn("Remediation sort request by {}: unsupported, ignoring", (Object)field);
                    } else {
                        queryString.append("e.").append(field);
                    }
                }
                if (ack) {
                    if (clause.getDirection() == Sort.Direction.ASC) {
                        queryString.append(" ASC");
                    } else {
                        queryString.append(" DESC");
                    }
                    queryString.append(',');
                }
            });
            queryString.deleteCharAt(queryString.length() - 1);
        }
        TypedQuery query = this.entityManager.createQuery(queryString.toString(), Remediation.class);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    @Override
    @Transactional
    public void deleteById(String key) {
        Optional.ofNullable((JPARemediation)this.entityManager.find(JPARemediation.class, (Object)key)).ifPresent(arg_0 -> ((EntityManager)this.entityManager).remove(arg_0));
    }
}

