/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.Assignment;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.DataAssociation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAssociationParser
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)DataAssociationParser.class.getName());

    public static void parseDataAssociation(DataAssociation dataAssociation, String elementName, XMLStreamReader xtr) {
        boolean readyWithDataAssociation = false;
        Assignment assignment = null;
        try {
            dataAssociation.setId(xtr.getAttributeValue(null, "id"));
            while (!readyWithDataAssociation && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "sourceRef".equals(xtr.getLocalName())) {
                    String sourceRef = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)sourceRef)) continue;
                    dataAssociation.setSourceRef(sourceRef.trim());
                    continue;
                }
                if (xtr.isStartElement() && "targetRef".equals(xtr.getLocalName())) {
                    String targetRef = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)targetRef)) continue;
                    dataAssociation.setTargetRef(targetRef.trim());
                    continue;
                }
                if (xtr.isStartElement() && "transformation".equals(xtr.getLocalName())) {
                    String transformation = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)transformation)) continue;
                    dataAssociation.setTransformation(transformation.trim());
                    continue;
                }
                if (xtr.isStartElement() && "assignment".equals(xtr.getLocalName())) {
                    assignment = new Assignment();
                    BpmnXMLUtil.addXMLLocation((BaseElement)assignment, xtr);
                    continue;
                }
                if (xtr.isStartElement() && "from".equals(xtr.getLocalName())) {
                    String from = xtr.getElementText();
                    if (assignment == null || !StringUtils.isNotEmpty((CharSequence)from)) continue;
                    assignment.setFrom(from.trim());
                    continue;
                }
                if (xtr.isStartElement() && "to".equals(xtr.getLocalName())) {
                    String to = xtr.getElementText();
                    if (assignment == null || !StringUtils.isNotEmpty((CharSequence)to)) continue;
                    assignment.setTo(to.trim());
                    continue;
                }
                if (xtr.isEndElement() && "assignment".equals(xtr.getLocalName())) {
                    if (!StringUtils.isNotEmpty((CharSequence)assignment.getFrom()) || !StringUtils.isNotEmpty((CharSequence)assignment.getTo())) continue;
                    dataAssociation.getAssignments().add(assignment);
                    continue;
                }
                if (!xtr.isEndElement() || !elementName.equals(xtr.getLocalName())) continue;
                readyWithDataAssociation = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing data association child elements", (Throwable)e);
        }
    }
}

