/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apereo.cas.authentication.AttributeMappingRequest;
import org.apereo.cas.authentication.PrincipalAttributesMapper;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class BaseMappedAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMappedAttributeReleasePolicy.class);
    private static final long serialVersionUID = -6249488544306639050L;
    @JsonProperty(value="allowedAttributes")
    private Map<String, Object> allowedAttributes = new TreeMap<String, Object>();

    public Map<String, Object> getAllowedAttributes() {
        return new TreeMap<String, Object>(this.allowedAttributes);
    }

    protected Map<String, List<Object>> authorizeMappedAttributes(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        TreeMap<String, List<Object>> resolvedAttributes = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attributes);
        resolvedAttributes.putAll(context.getReleasingAttributes());
        HashMap<String, List<Object>> attributesToRelease = new HashMap<String, List<Object>>();
        this.getAllowedAttributes().forEach((attributeName, value) -> {
            List<Object> mappedAttributes = this.determineMappedAttributes(value);
            LOGGER.trace("Attempting to map allowed attribute name [{}]", attributeName);
            mappedAttributes.forEach(mapped -> {
                String mappedAttributeName = mapped.toString();
                List<Object> attributeValue = this.getAttributeValue((Map<String, List<Object>>)resolvedAttributes, (String)attributeName, mappedAttributeName);
                LOGGER.debug("Mapping attribute [{}] to [{}] with value [{}]", new Object[]{attributeName, mappedAttributeName, attributeValue});
                AttributeMappingRequest mappingRequest = this.buildAttributeMappingRequest((Map<String, List<Object>>)resolvedAttributes, (String)attributeName, mappedAttributeName, attributeValue);
                Map<String, List<Object>> mappingResults = PrincipalAttributesMapper.defaultMapper().map(mappingRequest);
                attributesToRelease.putAll(mappingResults);
            });
        });
        return attributesToRelease;
    }

    protected AttributeMappingRequest buildAttributeMappingRequest(Map<String, List<Object>> resolvedAttributes, String attributeName, String mappedAttributeName, List<Object> attributeValue) {
        return ((AttributeMappingRequest.AttributeMappingRequestBuilder)((AttributeMappingRequest.AttributeMappingRequestBuilder)((AttributeMappingRequest.AttributeMappingRequestBuilder)((AttributeMappingRequest.AttributeMappingRequestBuilder)AttributeMappingRequest.builder().attributeName(attributeName)).mappedAttributeName(mappedAttributeName)).attributeValue(attributeValue)).resolvedAttributes(resolvedAttributes)).build();
    }

    protected List<Object> getAttributeValue(Map<String, List<Object>> resolvedAttributes, String attributeName, String mappedAttributeName) {
        return resolvedAttributes.get(attributeName);
    }

    protected List<Object> determineMappedAttributes(Object value) {
        return CollectionUtils.wrap((Object)value);
    }

    @Override
    @Generated
    public String toString() {
        return "BaseMappedAttributeReleasePolicy(super=" + super.toString() + ", allowedAttributes=" + String.valueOf(this.allowedAttributes) + ")";
    }

    @JsonProperty(value="allowedAttributes")
    @Generated
    public BaseMappedAttributeReleasePolicy setAllowedAttributes(Map<String, Object> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMappedAttributeReleasePolicy)) {
            return false;
        }
        BaseMappedAttributeReleasePolicy other = (BaseMappedAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$allowedAttributes = this.allowedAttributes;
        Map<String, Object> other$allowedAttributes = other.allowedAttributes;
        return !(this$allowedAttributes == null ? other$allowedAttributes != null : !((Object)this$allowedAttributes).equals(other$allowedAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseMappedAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $allowedAttributes = this.allowedAttributes;
        result = result * 59 + ($allowedAttributes == null ? 43 : ((Object)$allowedAttributes).hashCode());
        return result;
    }

    @Generated
    protected BaseMappedAttributeReleasePolicy() {
    }
}

