/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogLeaderEpochState;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogMetadataCache {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogMetadataCache.class);
    protected final ConcurrentMap<RemoteLogSegmentId, RemoteLogSegmentMetadata> idToSegmentMetadata = new ConcurrentHashMap<RemoteLogSegmentId, RemoteLogSegmentMetadata>();
    protected final ConcurrentMap<Integer, RemoteLogLeaderEpochState> leaderEpochEntries = new ConcurrentHashMap<Integer, RemoteLogLeaderEpochState>();
    private final CountDownLatch initializedLatch = new CountDownLatch(1);

    public void markInitialized() {
        this.initializedLatch.countDown();
    }

    public boolean isInitialized() {
        return this.initializedLatch.getCount() == 0L;
    }

    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(int leaderEpoch, long offset) {
        RemoteLogLeaderEpochState remoteLogLeaderEpochState = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
        if (remoteLogLeaderEpochState == null) {
            return Optional.empty();
        }
        RemoteLogSegmentId remoteLogSegmentId = remoteLogLeaderEpochState.floorEntry(offset);
        if (remoteLogSegmentId == null) {
            return Optional.empty();
        }
        RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(remoteLogSegmentId);
        Map.Entry nextEntry = metadata.segmentLeaderEpochs().higherEntry(leaderEpoch);
        long epochEndOffset = nextEntry != null ? (Long)nextEntry.getValue() - 1L : metadata.endOffset();
        return offset > epochEndOffset ? Optional.empty() : Optional.of(metadata);
    }

    public void updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate metadataUpdate) throws RemoteResourceNotFoundException {
        log.debug("Updating remote log segment metadata: [{}]", (Object)metadataUpdate);
        Objects.requireNonNull(metadataUpdate, "metadataUpdate can not be null");
        RemoteLogSegmentState targetState = metadataUpdate.state();
        RemoteLogSegmentId remoteLogSegmentId = metadataUpdate.remoteLogSegmentId();
        RemoteLogSegmentMetadata existingMetadata = (RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(remoteLogSegmentId);
        if (!this.isInitialized() && existingMetadata == null) {
            log.debug("Dropping the event: {} as the base-metadata about the segment was already removed", (Object)metadataUpdate);
            return;
        }
        if (existingMetadata == null) {
            throw new RemoteResourceNotFoundException("No remote log segment metadata found for :" + remoteLogSegmentId);
        }
        boolean isValid = this.checkStateTransition(existingMetadata.state(), targetState, metadataUpdate.remoteLogSegmentId());
        if (!isValid) {
            return;
        }
        switch (targetState) {
            case COPY_SEGMENT_STARTED: {
                throw new IllegalArgumentException("metadataUpdate: " + metadataUpdate + " with state " + RemoteLogSegmentState.COPY_SEGMENT_STARTED + " can not be updated");
            }
            case COPY_SEGMENT_FINISHED: {
                this.handleSegmentWithCopySegmentFinishedState(existingMetadata.createWithUpdates(metadataUpdate));
                break;
            }
            case DELETE_SEGMENT_STARTED: {
                this.handleSegmentWithDeleteSegmentStartedState(existingMetadata.createWithUpdates(metadataUpdate));
                break;
            }
            case DELETE_SEGMENT_FINISHED: {
                this.handleSegmentWithDeleteSegmentFinishedState(existingMetadata.createWithUpdates(metadataUpdate));
                break;
            }
            default: {
                throw new IllegalArgumentException("Metadata with the state " + targetState + " is not supported");
            }
        }
    }

    protected final void handleSegmentWithCopySegmentFinishedState(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        this.doHandleSegmentStateTransitionForLeaderEpochs(remoteLogSegmentMetadata, (leaderEpoch, remoteLogLeaderEpochState, startOffset, segmentId) -> {
            long leaderEpochEndOffset = RemoteLogMetadataCache.highestOffsetForEpoch(leaderEpoch, remoteLogSegmentMetadata);
            remoteLogLeaderEpochState.handleSegmentWithCopySegmentFinishedState(startOffset, segmentId, leaderEpochEndOffset);
        });
        this.idToSegmentMetadata.put(remoteLogSegmentMetadata.remoteLogSegmentId(), remoteLogSegmentMetadata);
    }

    protected final void handleSegmentWithDeleteSegmentStartedState(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Cleaning up the state for : [{}]", (Object)remoteLogSegmentMetadata);
        this.doHandleSegmentStateTransitionForLeaderEpochs(remoteLogSegmentMetadata, (leaderEpoch, remoteLogLeaderEpochState, startOffset, segmentId) -> remoteLogLeaderEpochState.handleSegmentWithDeleteSegmentStartedState(startOffset, segmentId));
        this.idToSegmentMetadata.put(remoteLogSegmentMetadata.remoteLogSegmentId(), remoteLogSegmentMetadata);
    }

    private void handleSegmentWithDeleteSegmentFinishedState(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Removing the entry as it reached the terminal state: [{}]", (Object)remoteLogSegmentMetadata);
        this.doHandleSegmentStateTransitionForLeaderEpochs(remoteLogSegmentMetadata, (leaderEpoch, remoteLogLeaderEpochState, startOffset, segmentId) -> remoteLogLeaderEpochState.handleSegmentWithDeleteSegmentFinishedState(segmentId));
        this.idToSegmentMetadata.remove(remoteLogSegmentMetadata.remoteLogSegmentId());
    }

    private void doHandleSegmentStateTransitionForLeaderEpochs(RemoteLogSegmentMetadata remoteLogSegmentMetadata, RemoteLogLeaderEpochState.Action action) {
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        NavigableMap leaderEpochToOffset = remoteLogSegmentMetadata.segmentLeaderEpochs();
        for (Map.Entry entry : leaderEpochToOffset.entrySet()) {
            Integer leaderEpoch = (Integer)entry.getKey();
            Long startOffset = (Long)entry.getValue();
            RemoteLogLeaderEpochState remoteLogLeaderEpochState = this.leaderEpochEntries.computeIfAbsent(leaderEpoch, x -> new RemoteLogLeaderEpochState());
            action.accept(leaderEpoch, remoteLogLeaderEpochState, startOffset, remoteLogSegmentId);
        }
    }

    private static long highestOffsetForEpoch(Integer leaderEpoch, RemoteLogSegmentMetadata segmentMetadata) {
        NavigableMap epochToOffset = segmentMetadata.segmentLeaderEpochs();
        Map.Entry nextEntry = epochToOffset.higherEntry(leaderEpoch);
        return nextEntry != null ? (Long)nextEntry.getValue() - 1L : segmentMetadata.endOffset();
    }

    public Iterator<RemoteLogSegmentMetadata> listAllRemoteLogSegments() {
        return Collections.unmodifiableCollection(this.idToSegmentMetadata.values()).iterator();
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(int leaderEpoch) throws RemoteResourceNotFoundException {
        RemoteLogLeaderEpochState remoteLogLeaderEpochState = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
        if (remoteLogLeaderEpochState == null) {
            return Collections.emptyIterator();
        }
        return remoteLogLeaderEpochState.listAllRemoteLogSegments(this.idToSegmentMetadata);
    }

    public Optional<Long> highestOffsetForEpoch(int leaderEpoch) {
        RemoteLogLeaderEpochState entry = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
        return entry != null ? Optional.ofNullable(entry.highestLogOffset()) : Optional.empty();
    }

    public void addCopyInProgressSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Adding to in-progress state: [{}]", (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        if (remoteLogSegmentMetadata.state() != RemoteLogSegmentState.COPY_SEGMENT_STARTED) {
            throw new IllegalArgumentException("Given remoteLogSegmentMetadata:" + remoteLogSegmentMetadata + " should have state as " + RemoteLogSegmentState.COPY_SEGMENT_STARTED + " but it contains state as: " + remoteLogSegmentMetadata.state());
        }
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        RemoteLogSegmentMetadata existingMetadata = (RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(remoteLogSegmentId);
        boolean isValid = this.checkStateTransition(existingMetadata != null ? existingMetadata.state() : null, remoteLogSegmentMetadata.state(), remoteLogSegmentMetadata.remoteLogSegmentId());
        if (!isValid) {
            return;
        }
        for (Integer epoch : remoteLogSegmentMetadata.segmentLeaderEpochs().keySet()) {
            this.leaderEpochEntries.computeIfAbsent(epoch, leaderEpoch -> new RemoteLogLeaderEpochState()).handleSegmentWithCopySegmentStartedState(remoteLogSegmentId);
        }
        this.idToSegmentMetadata.put(remoteLogSegmentId, remoteLogSegmentMetadata);
    }

    private boolean checkStateTransition(RemoteLogSegmentState existingState, RemoteLogSegmentState targetState, RemoteLogSegmentId segmentId) {
        boolean isValid = RemoteLogSegmentState.isValidTransition((RemoteLogSegmentState)existingState, (RemoteLogSegmentState)targetState);
        if (!isValid) {
            log.error("Current state: {} can not be transitioned to target state: {}, segmentId: {}. Dropping the event", new Object[]{existingState, targetState, segmentId});
        }
        return isValid;
    }
}

