/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.configuration;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apereo.cas.client.configuration.BaseConfigurationStrategy;
import org.apereo.cas.client.configuration.ConfigurationKey;
import org.apereo.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesConfigurationStrategyImpl
extends BaseConfigurationStrategy {
    private static final String CONFIGURATION_FILE_LOCATION = "configFileLocation";
    private static final String DEFAULT_CONFIGURATION_FILE_LOCATION = "/etc/java-cas-client.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfigurationStrategyImpl.class);
    private final Properties properties = new Properties();
    private String simpleFilterName;

    @Override
    public void init(FilterConfig filterConfig, Class<? extends Filter> filterClazz) {
        String fileLocationFromServletConfig;
        boolean servletContextFileLoad;
        this.simpleFilterName = filterClazz.getSimpleName();
        String fileLocationFromFilterConfig = filterConfig.getInitParameter(CONFIGURATION_FILE_LOCATION);
        boolean filterConfigFileLoad = this.loadPropertiesFromFile(fileLocationFromFilterConfig);
        if (!filterConfigFileLoad && !(servletContextFileLoad = this.loadPropertiesFromFile(fileLocationFromServletConfig = filterConfig.getServletContext().getInitParameter(CONFIGURATION_FILE_LOCATION)))) {
            boolean defaultConfigFileLoaded = this.loadPropertiesFromFile(DEFAULT_CONFIGURATION_FILE_LOCATION);
            CommonUtils.assertTrue(defaultConfigFileLoaded, "unable to load properties to configure CAS client");
        }
    }

    @Override
    protected String get(ConfigurationKey configurationKey) {
        String property = configurationKey.getName();
        String filterSpecificProperty = this.simpleFilterName + "." + property;
        String filterSpecificValue = this.properties.getProperty(filterSpecificProperty);
        if (CommonUtils.isNotEmpty(filterSpecificValue)) {
            return filterSpecificValue;
        }
        return this.properties.getProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPropertiesFromFile(String file) {
        boolean bl;
        if (CommonUtils.isEmpty(file)) {
            return false;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.properties.load(fis);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LOGGER.warn("Unable to load properties for file {}", (Object)file, (Object)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CommonUtils.closeQuietly(fis);
                throw throwable;
            }
            CommonUtils.closeQuietly(fis);
            return bl2;
        }
        CommonUtils.closeQuietly(fis);
        return bl;
    }
}

