/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.jaas;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.jaas.AssertionPrincipal;
import org.apereo.cas.client.util.AbstractCasFilter;
import org.apereo.cas.client.util.WebUtils;

public final class Servlet3AuthenticationFilter
extends AbstractCasFilter {
    public Servlet3AuthenticationFilter() {
        super(Protocol.CAS2);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        String ticket = WebUtils.safeGetParameter(request, this.getProtocol().getArtifactParameterName());
        if (session != null && session.getAttribute("_const_cas_assertion_") == null && ticket != null) {
            try {
                String service = this.constructServiceUrl(request, response);
                this.logger.debug("Attempting CAS ticket validation with service={} and ticket={}", (Object)service, (Object)ticket);
                request.login(service, ticket);
                if (!(request.getUserPrincipal() instanceof AssertionPrincipal)) {
                    this.logger.debug("Aborting -- principal is not of type AssertionPrincipal");
                    throw new GeneralSecurityException("JAAS authentication did not produce CAS AssertionPrincipal.");
                }
                AssertionPrincipal principal = (AssertionPrincipal)request.getUserPrincipal();
                this.logger.debug("Installing CAS assertion into session.");
                request.getSession().setAttribute("_const_cas_assertion_", (Object)principal.getAssertion());
            }
            catch (ServletException e) {
                this.logger.debug("JAAS authentication failed.");
                response.sendError(403, e.getMessage());
            }
            catch (GeneralSecurityException e) {
                response.sendError(403, e.getMessage());
            }
        } else if (session != null && request.getUserPrincipal() == null) {
            this.logger.info("User principal not found.  Removing CAS assertion from session to force re-authentication.");
            session.removeAttribute("_const_cas_assertion_");
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

