/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation;

import jakarta.servlet.FilterConfig;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.ssl.HttpsURLConnectionFactory;
import org.apereo.cas.client.validation.AbstractTicketValidationFilter;
import org.apereo.cas.client.validation.Cas10TicketValidator;
import org.apereo.cas.client.validation.TicketValidator;

public class Cas10TicketValidationFilter
extends AbstractTicketValidationFilter {
    public Cas10TicketValidationFilter() {
        super(Protocol.CAS1);
    }

    @Override
    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        String casServerUrlPrefix = this.getString(ConfigurationKeys.CAS_SERVER_URL_PREFIX);
        Cas10TicketValidator validator = new Cas10TicketValidator(casServerUrlPrefix);
        validator.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
        HttpsURLConnectionFactory factory = new HttpsURLConnectionFactory(this.getHostnameVerifier(), this.getSSLConfig());
        validator.setURLConnectionFactory(factory);
        validator.setEncoding(this.getString(ConfigurationKeys.ENCODING));
        return validator;
    }
}

