/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.thymeleaf.engine.AbstractProcessableElementTag;
import org.thymeleaf.engine.Attribute;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.Attributes;
import org.thymeleaf.engine.ElementDefinition;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IModelVisitor;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.templatemode.TemplateMode;

final class OpenElementTag
extends AbstractProcessableElementTag
implements IOpenElementTag,
IEngineTemplateEvent {
    OpenElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes, boolean synthetic) {
        super(templateMode, elementDefinition, elementCompleteName, attributes, synthetic);
    }

    OpenElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes, boolean synthetic, String templateName, int line, int col) {
        super(templateMode, elementDefinition, elementCompleteName, attributes, synthetic, templateName, line, col);
    }

    @Override
    OpenElementTag setAttribute(AttributeDefinitions attributeDefinitions, AttributeDefinition attributeDefinition, String completeName, String value, AttributeValueQuotes valueQuotes) {
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        Attributes newAttributes = oldAttributes.setAttribute(attributeDefinitions, this.templateMode, attributeDefinition, completeName, value, valueQuotes);
        return new OpenElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.templateName, this.line, this.col);
    }

    @Override
    OpenElementTag replaceAttribute(AttributeDefinitions attributeDefinitions, AttributeName oldName, AttributeDefinition newAttributeDefinition, String completeNewName, String value, AttributeValueQuotes valueQuotes) {
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        Attributes newAttributes = oldAttributes.replaceAttribute(attributeDefinitions, this.templateMode, oldName, newAttributeDefinition, completeNewName, value, valueQuotes);
        return new OpenElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.templateName, this.line, this.col);
    }

    @Override
    OpenElementTag removeAttribute(String prefix, String name) {
        Attributes newAttributes;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes = oldAttributes.removeAttribute(this.templateMode, prefix, name))) {
            return this;
        }
        return new OpenElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.templateName, this.line, this.col);
    }

    @Override
    OpenElementTag removeAttribute(String completeName) {
        Attributes newAttributes;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes = oldAttributes.removeAttribute(this.templateMode, completeName))) {
            return this;
        }
        return new OpenElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.templateName, this.line, this.col);
    }

    @Override
    OpenElementTag removeAttribute(AttributeName attributeName) {
        Attributes newAttributes;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes = oldAttributes.removeAttribute(attributeName))) {
            return this;
        }
        return new OpenElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.templateName, this.line, this.col);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.synthetic) {
            return;
        }
        if (this.templateMode.isText()) {
            writer.write("[#");
            writer.write(this.elementCompleteName);
            if (this.attributes != null) {
                this.attributes.write(writer);
            }
            writer.write("]");
            return;
        }
        writer.write(60);
        writer.write(this.elementCompleteName);
        if (this.attributes != null) {
            this.attributes.write(writer);
        }
        writer.write(62);
    }

    static OpenElementTag asEngineOpenElementTag(IOpenElementTag openElementTag) {
        Attributes attributes;
        if (openElementTag instanceof OpenElementTag) {
            return (OpenElementTag)openElementTag;
        }
        IAttribute[] originalAttributeArray = openElementTag.getAllAttributes();
        if (originalAttributeArray == null || originalAttributeArray.length == 0) {
            attributes = null;
        } else {
            Object[] newInnerWhiteSpaces;
            Attribute[] newAttributeArray = new Attribute[originalAttributeArray.length];
            for (int i = 0; i < originalAttributeArray.length; ++i) {
                IAttribute originalAttribute = originalAttributeArray[i];
                newAttributeArray[i] = new Attribute(originalAttribute.getAttributeDefinition(), originalAttribute.getAttributeCompleteName(), originalAttribute.getOperator(), originalAttribute.getValue(), originalAttribute.getValueQuotes(), originalAttribute.getTemplateName(), originalAttribute.getLine(), originalAttribute.getCol());
            }
            if (newAttributeArray.length == 1) {
                newInnerWhiteSpaces = Attributes.DEFAULT_WHITE_SPACE_ARRAY;
            } else {
                newInnerWhiteSpaces = new String[newAttributeArray.length];
                Arrays.fill(newInnerWhiteSpaces, " ");
            }
            attributes = new Attributes(newAttributeArray, (String[])newInnerWhiteSpaces);
        }
        return new OpenElementTag(openElementTag.getTemplateMode(), openElementTag.getElementDefinition(), openElementTag.getElementCompleteName(), attributes, openElementTag.isSynthetic(), openElementTag.getTemplateName(), openElementTag.getLine(), openElementTag.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleOpenElement(this);
    }
}

