/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.schema;

import com.okta.sdk.resource.api.SchemaApi;
import com.okta.sdk.resource.model.UserSchemaAttribute;
import com.okta.sdk.resource.model.UserSchemaDefinitions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.tirasa.connid.bundles.okta.OktaConnector;
import net.tirasa.connid.bundles.okta.utils.OktaAttribute;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

class OktaSchemaBuilder {
    private static final Log LOG = Log.getLog(OktaSchemaBuilder.class);
    private final SchemaApi schemaApi;
    private Schema schema;

    protected OktaSchemaBuilder(SchemaApi schemaApi) {
        this.schemaApi = schemaApi;
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    private void buildSchema() {
        SchemaBuilder schemaBld = new SchemaBuilder(OktaConnector.class);
        schemaBld.defineObjectClass(this.build(ObjectClass.ACCOUNT_NAME).addAllAttributeInfo(this.buildAccountAttrInfos()).build());
        schemaBld.defineObjectClass(this.build(ObjectClass.GROUP_NAME).addAllAttributeInfo(this.buildGroupAttrInfos()).build());
        schemaBld.defineObjectClass(this.build(OktaConnector.APPLICATION_NAME).addAllAttributeInfo(this.buildApplicationAttrInfos()).build());
        this.schema = schemaBld.build();
    }

    private ObjectClassInfoBuilder build(String objectClassName) {
        ObjectClassInfoBuilder objClassBld = new ObjectClassInfoBuilder();
        objClassBld.setType(objectClassName);
        objClassBld.setContainer(false);
        return objClassBld;
    }

    private Optional<AttributeInfo> map(String key, UserSchemaAttribute attr, List<String> req) {
        return Optional.ofNullable(attr).map(prop -> {
            AttributeInfoBuilder attributeInfo = new AttributeInfoBuilder();
            attributeInfo.setRequired(req.contains(key));
            return AttributeInfoBuilder.build((String)key, OktaAttribute.getType(prop.getType().getValue()));
        });
    }

    private Collection<AttributeInfo> buildAccountAttrInfos() {
        LOG.ok("Retrieve User schema profile", new Object[0]);
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        UserSchemaDefinitions defs = this.schemaApi.getUserSchema("default").getDefinitions();
        List<String> reqBase = Optional.ofNullable(defs.getBase().getRequired()).orElse(Collections.emptyList());
        this.map("city", defs.getBase().getProperties().getCity(), reqBase).ifPresent(attributeInfos::add);
        this.map("costCenter", defs.getBase().getProperties().getCostCenter(), reqBase).ifPresent(attributeInfos::add);
        this.map("countryCode", defs.getBase().getProperties().getCountryCode(), reqBase).ifPresent(attributeInfos::add);
        this.map("department", defs.getBase().getProperties().getDepartment(), reqBase).ifPresent(attributeInfos::add);
        this.map("displayName", defs.getBase().getProperties().getDisplayName(), reqBase).ifPresent(attributeInfos::add);
        this.map("division", defs.getBase().getProperties().getDivision(), reqBase).ifPresent(attributeInfos::add);
        this.map("email", defs.getBase().getProperties().getEmail(), reqBase).ifPresent(attributeInfos::add);
        this.map("employeeNumber", defs.getBase().getProperties().getEmployeeNumber(), reqBase).ifPresent(attributeInfos::add);
        this.map("firstName", defs.getBase().getProperties().getFirstName(), reqBase).ifPresent(attributeInfos::add);
        this.map("honorificPrefix", defs.getBase().getProperties().getHonorificPrefix(), reqBase).ifPresent(attributeInfos::add);
        this.map("honorificSuffix", defs.getBase().getProperties().getHonorificSuffix(), reqBase).ifPresent(attributeInfos::add);
        this.map("lastName", defs.getBase().getProperties().getLastName(), reqBase).ifPresent(attributeInfos::add);
        this.map("locale", defs.getBase().getProperties().getLocale(), reqBase).ifPresent(attributeInfos::add);
        this.map("login", defs.getBase().getProperties().getLogin(), reqBase).ifPresent(attributeInfos::add);
        this.map("manager", defs.getBase().getProperties().getManager(), reqBase).ifPresent(attributeInfos::add);
        this.map("managerId", defs.getBase().getProperties().getManagerId(), reqBase).ifPresent(attributeInfos::add);
        this.map("middleName", defs.getBase().getProperties().getMiddleName(), reqBase).ifPresent(attributeInfos::add);
        this.map("mobilePhone", defs.getBase().getProperties().getMobilePhone(), reqBase).ifPresent(attributeInfos::add);
        this.map("nickName", defs.getBase().getProperties().getNickName(), reqBase).ifPresent(attributeInfos::add);
        this.map("organization", defs.getBase().getProperties().getOrganization(), reqBase).ifPresent(attributeInfos::add);
        this.map("postalAddress", defs.getBase().getProperties().getPostalAddress(), reqBase).ifPresent(attributeInfos::add);
        this.map("preferredLanguage", defs.getBase().getProperties().getPreferredLanguage(), reqBase).ifPresent(attributeInfos::add);
        this.map("primaryPhone", defs.getBase().getProperties().getPrimaryPhone(), reqBase).ifPresent(attributeInfos::add);
        this.map("profileUrl", defs.getBase().getProperties().getProfileUrl(), reqBase).ifPresent(attributeInfos::add);
        this.map("secondEmail", defs.getBase().getProperties().getSecondEmail(), reqBase).ifPresent(attributeInfos::add);
        this.map("state", defs.getBase().getProperties().getState(), reqBase).ifPresent(attributeInfos::add);
        this.map("streetAddress", defs.getBase().getProperties().getStreetAddress(), reqBase).ifPresent(attributeInfos::add);
        this.map("timezone", defs.getBase().getProperties().getTimezone(), reqBase).ifPresent(attributeInfos::add);
        this.map("title", defs.getBase().getProperties().getTitle(), reqBase).ifPresent(attributeInfos::add);
        this.map("userType", defs.getBase().getProperties().getUserType(), reqBase).ifPresent(attributeInfos::add);
        this.map("zipCode", defs.getBase().getProperties().getZipCode(), reqBase).ifPresent(attributeInfos::add);
        List reqCustom = Optional.ofNullable(defs.getCustom().getRequired()).orElse(Collections.emptyList());
        defs.getCustom().getProperties().forEach((key, prop) -> this.map((String)key, (UserSchemaAttribute)prop, reqCustom).ifPresent(attributeInfos::add));
        AttributeInfoBuilder attributeInfo = new AttributeInfoBuilder();
        attributeInfo.setRequired(true);
        attributeInfos.add(AttributeInfoBuilder.build((String)"id", String.class));
        attributeInfos.add(AttributeInfoBuilder.define((String)"oktaGroups", String.class).setMultiValued(true).setReturnedByDefault(false).build());
        return attributeInfos;
    }

    private Collection<AttributeInfo> buildGroupAttrInfos() {
        LOG.ok("Retrieve Group schema profile", new Object[0]);
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        attributeInfos.add(AttributeInfoBuilder.build((String)"id", String.class));
        attributeInfos.add(AttributeInfoBuilder.build((String)"name", String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributeInfos.add(AttributeInfoBuilder.build((String)"description", String.class));
        return attributeInfos;
    }

    private Collection<AttributeInfo> buildApplicationAttrInfos() {
        LOG.ok("Retrieve Application schema profile", new Object[0]);
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        attributeInfos.add(AttributeInfoBuilder.build((String)"id", String.class));
        attributeInfos.add(AttributeInfoBuilder.build((String)"name", String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributeInfos.add(AttributeInfoBuilder.build((String)"label", String.class));
        return attributeInfos;
    }
}

