/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.NotificationTO;

public class NotificationWrapper
extends EntityWrapper<NotificationTO> {
    private static final long serialVersionUID = 8058288034211558376L;
    private List<Pair<String, List<SearchClause>>> aboutClauses;
    private List<SearchClause> recipientClauses;

    public NotificationWrapper(NotificationTO notificationTO) {
        super((EntityTO)notificationTO);
    }

    public final String getKey() {
        return ((NotificationTO)this.getInnerObject()).getKey();
    }

    public List<Pair<String, List<SearchClause>>> getAboutClauses() {
        if (this.aboutClauses == null) {
            this.aboutClauses = SearchUtils.getSearchClauses(((NotificationTO)this.getInnerObject()).getAbouts()).entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((List)entry.getValue()))).collect(Collectors.toList());
        }
        return this.aboutClauses;
    }

    public void setAboutClauses(List<Pair<String, List<SearchClause>>> dynClauses) {
        this.aboutClauses = dynClauses;
    }

    public List<SearchClause> getRecipientClauses() {
        if (this.recipientClauses == null) {
            this.recipientClauses = SearchUtils.getSearchClauses(((NotificationTO)this.getInnerObject()).getRecipientsFIQL());
        }
        return this.recipientClauses;
    }

    public void setRecipientClauses(List<SearchClause> dynClauses) {
        this.recipientClauses = dynClauses;
    }

    public Map<String, String> getAboutFIQLs() {
        if (CollectionUtils.isEmpty(this.aboutClauses) || ((List)this.aboutClauses.getFirst().getValue()).isEmpty()) {
            return ((NotificationTO)this.getInnerObject()).getAbouts();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (Pair<String, List<SearchClause>> pair : this.aboutClauses) {
            res.put((String)pair.getLeft(), SearchUtils.buildFIQL((List)pair.getRight(), switch ((String)pair.getLeft()) {
                case "USER" -> SyncopeClient.getUserSearchConditionBuilder();
                case "GROUP" -> SyncopeClient.getGroupSearchConditionBuilder();
                default -> SyncopeClient.getAnyObjectSearchConditionBuilder((String)((String)pair.getLeft()));
            }));
        }
        return res;
    }

    private String getRecipientsFIQL() {
        if (CollectionUtils.isEmpty(this.recipientClauses)) {
            return null;
        }
        return SearchUtils.buildFIQL(this.recipientClauses, SyncopeClient.getUserSearchConditionBuilder());
    }

    public NotificationTO fillAboutConditions() {
        ((NotificationTO)this.getInnerObject()).getAbouts().clear();
        ((NotificationTO)this.getInnerObject()).getAbouts().putAll(this.getAboutFIQLs());
        return (NotificationTO)this.getInnerObject();
    }

    public NotificationTO fillRecipientConditions() {
        ((NotificationTO)this.getInnerObject()).setRecipientsFIQL(this.getRecipientsFIQL());
        return (NotificationTO)this.getInnerObject();
    }
}

