/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.AnyObjectFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.search.SyncopeFiqlParser;
import org.apache.syncope.common.lib.search.SyncopeFiqlSearchCondition;
import org.apache.syncope.common.lib.search.SyncopeProperty;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchUtils
implements Serializable {
    private static final long serialVersionUID = 398381905376547084L;
    public static final Function<SearchClause, CompleteCondition> NO_CUSTOM_CONDITION = clause -> null;
    private static final Logger LOG = LoggerFactory.getLogger(SearchUtils.class);
    private static final BidiMap<String, String> ENCODINGS = new DualHashBidiMap<String, String>(){
        private static final long serialVersionUID = 5636572627689425575L;
        {
            this.put(",", "%252C");
            this.put(";", "%253B");
            this.put("+", "%252B");
        }
    };

    public static Pattern getTypeConditionPattern(String type) {
        return Pattern.compile(String.format(";\\$type==%s|\\$type==%s;", type, type));
    }

    public static Map<String, List<SearchClause>> getSearchClauses(Map<String, String> fiql) {
        return fiql.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SearchUtils.getSearchClauses(((String)e.getValue()).replaceAll(SearchUtils.getTypeConditionPattern((String)e.getKey()).pattern(), ""))));
    }

    public static List<SearchClause> getSearchClauses(String fiql) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        if (StringUtils.isNotBlank((CharSequence)fiql)) {
            try {
                SyncopeFiqlParser fiqlParser = new SyncopeFiqlParser(SearchBean.class, AbstractFiqlSearchConditionBuilder.CONTEXTUAL_PROPERTIES);
                clauses.addAll(SearchUtils.getSearchClauses((SearchCondition<SearchBean>)fiqlParser.parse(fiql)));
            }
            catch (Exception e) {
                LOG.error("Unparseable FIQL expression '{}'", (Object)fiql, (Object)e);
            }
        }
        return clauses;
    }

    private static List<SearchClause> getSearchClauses(SearchCondition<SearchBean> sc) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        if (sc.getStatement() == null) {
            clauses.addAll(SearchUtils.getCompoundSearchClauses(sc));
        } else {
            clauses.add(SearchUtils.getPrimitiveSearchClause(sc));
        }
        return clauses;
    }

    private static List<SearchClause> getCompoundSearchClauses(SearchCondition<SearchBean> sc) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        sc.getSearchConditions().forEach(searchCondition -> {
            if (searchCondition.getStatement() == null) {
                clauses.addAll(SearchUtils.getCompoundSearchClauses((SearchCondition<SearchBean>)searchCondition));
            } else {
                SearchClause clause = SearchUtils.getPrimitiveSearchClause((SearchCondition<SearchBean>)searchCondition);
                if (sc.getConditionType() == ConditionType.AND) {
                    clause.setOperator(SearchClause.Operator.AND);
                }
                if (sc.getConditionType() == ConditionType.OR) {
                    clause.setOperator(SearchClause.Operator.OR);
                }
                clauses.add(clause);
            }
        });
        return clauses;
    }

    private static SearchClause getPrimitiveSearchClause(SearchCondition<SearchBean> sc) {
        SearchClause clause = new SearchClause();
        String property = (String)((SearchBean)sc.getCondition()).getKeySet().iterator().next();
        clause.setProperty(property);
        String value = ENCODINGS.values().stream().reduce(((SearchBean)sc.getCondition()).get(property), (s, v) -> s.replace((CharSequence)v, (CharSequence)ENCODINGS.getKey(v)));
        clause.setValue(value);
        LOG.debug("Condition: {}", sc.getCondition());
        if (SpecialAttr.ROLES.toString().equals(property)) {
            clause.setType(SearchClause.Type.ROLE_MEMBERSHIP);
            clause.setProperty(value);
        } else if (SpecialAttr.RELATIONSHIPS.toString().equals(property)) {
            clause.setType(SearchClause.Type.RELATIONSHIP);
            clause.setProperty(value);
        } else if (SpecialAttr.RELATIONSHIP_TYPES.toString().equals(property)) {
            clause.setType(SearchClause.Type.RELATIONSHIP);
            clause.setProperty(value);
        } else if (SpecialAttr.GROUPS.toString().equals(property)) {
            clause.setType(SearchClause.Type.GROUP_MEMBERSHIP);
            clause.setProperty(value);
        } else if (SpecialAttr.AUX_CLASSES.toString().equals(property)) {
            clause.setType(SearchClause.Type.AUX_CLASS);
            clause.setProperty(value);
        } else if (SpecialAttr.RESOURCES.toString().equals(property)) {
            clause.setType(SearchClause.Type.RESOURCE);
            clause.setProperty(value);
        } else if (SpecialAttr.MEMBER.toString().equals(property)) {
            clause.setType(SearchClause.Type.GROUP_MEMBER);
            clause.setProperty(value);
        } else if (property.startsWith("$")) {
            clause.setType(SearchClause.Type.CUSTOM);
            clause.setProperty(value);
        } else {
            clause.setType(SearchClause.Type.ATTRIBUTE);
        }
        ConditionType ct = sc.getConditionType();
        if (sc instanceof SyncopeFiqlSearchCondition) {
            SyncopeFiqlSearchCondition sfsc = (SyncopeFiqlSearchCondition)sc;
            if (sc.getConditionType() == ConditionType.CUSTOM) {
                if ("=~".equals(sfsc.getOperator())) {
                    ct = ConditionType.EQUALS;
                } else if ("!~".equals(sfsc.getOperator())) {
                    ct = ConditionType.NOT_EQUALS;
                }
            }
        }
        switch (ct) {
            case EQUALS: {
                if (SpecialAttr.RELATIONSHIP_TYPES.toString().equals(property)) {
                    clause.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.EQUALS : SearchClause.Comparator.IS_NULL);
                    break;
                }
                clause.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.IS_NULL : SearchClause.Comparator.EQUALS);
                break;
            }
            case NOT_EQUALS: {
                if (SpecialAttr.RELATIONSHIP_TYPES.toString().equals(property)) {
                    clause.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.NOT_EQUALS : SearchClause.Comparator.IS_NOT_NULL);
                    break;
                }
                clause.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.IS_NOT_NULL : SearchClause.Comparator.NOT_EQUALS);
                break;
            }
            case GREATER_OR_EQUALS: {
                clause.setComparator(SearchClause.Comparator.GREATER_OR_EQUALS);
                break;
            }
            case GREATER_THAN: {
                clause.setComparator(SearchClause.Comparator.GREATER_THAN);
                break;
            }
            case LESS_OR_EQUALS: {
                clause.setComparator(SearchClause.Comparator.LESS_OR_EQUALS);
                break;
            }
            case LESS_THAN: {
                clause.setComparator(SearchClause.Comparator.LESS_THAN);
                break;
            }
        }
        return clause;
    }

    public static String buildFIQL(List<SearchClause> clauses, AbstractFiqlSearchConditionBuilder<?, ?, ?> builder) {
        return SearchUtils.buildFIQL(clauses, builder, Map.of(), NO_CUSTOM_CONDITION);
    }

    public static String buildFIQL(List<SearchClause> clauses, AbstractFiqlSearchConditionBuilder<?, ?, ?> builder, Map<String, PlainSchemaTO> availableSchemaTypes, Function<SearchClause, CompleteCondition> customCondition) {
        LOG.debug("Generating FIQL from {}", clauses);
        CompleteCondition condition = null;
        boolean notTheFirst = false;
        for (SearchClause clause : clauses) {
            CompleteCondition prevCondition = condition;
            if (clause.getType() != null) {
                String value = clause.getValue() == null ? null : ENCODINGS.keySet().stream().reduce(clause.getValue(), (s, k) -> s.replace((CharSequence)k, (CharSequence)ENCODINGS.get(k)));
                block0 : switch (clause.getType()) {
                    case GROUP_MEMBER: {
                        if (!(builder instanceof GroupFiqlSearchConditionBuilder)) break;
                        switch (clause.getComparator()) {
                            case EQUALS: {
                                condition = ((GroupFiqlSearchConditionBuilder)builder).withMembers(value, new String[0]);
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = ((GroupFiqlSearchConditionBuilder)builder).withoutMembers(value, new String[0]);
                                break block0;
                            }
                        }
                        break;
                    }
                    case GROUP_MEMBERSHIP: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        String groupKey = clause.getProperty();
                        if (builder instanceof UserFiqlSearchConditionBuilder) {
                            UserFiqlSearchConditionBuilder conditionBuilder = (UserFiqlSearchConditionBuilder)builder;
                            condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? conditionBuilder.inGroups(groupKey, new String[0]) : conditionBuilder.notInGroups(groupKey, new String[0]);
                            break;
                        }
                        condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? ((AnyObjectFiqlSearchConditionBuilder)builder).inGroups(groupKey, new String[0]) : ((AnyObjectFiqlSearchConditionBuilder)builder).notInGroups(groupKey, new String[0]);
                        break;
                    }
                    case AUX_CLASS: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? builder.hasAuxClasses(clause.getProperty(), new String[0]) : builder.hasNotAuxClasses(clause.getProperty(), new String[0]);
                        break;
                    }
                    case RESOURCE: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? builder.hasResources(clause.getProperty(), new String[0]) : builder.hasNotResources(clause.getProperty(), new String[0]);
                        break;
                    }
                    case ATTRIBUTE: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        boolean isLong = false;
                        boolean isDouble = false;
                        boolean isBoolean = false;
                        if (availableSchemaTypes.get(clause.getProperty()) != null) {
                            switch (availableSchemaTypes.get(clause.getProperty()).getType()) {
                                case Long: {
                                    isLong = true;
                                    break;
                                }
                                case Double: {
                                    isDouble = true;
                                    break;
                                }
                                case Boolean: {
                                    isBoolean = true;
                                    break;
                                }
                            }
                        }
                        SyncopeProperty property = builder.is(clause.getProperty());
                        switch (clause.getComparator()) {
                            case IS_NULL: {
                                condition = builder.isNull(clause.getProperty());
                                break block0;
                            }
                            case IS_NOT_NULL: {
                                condition = builder.isNotNull(clause.getProperty());
                                break block0;
                            }
                            case LESS_THAN: {
                                condition = isLong ? property.lessThan(Long.valueOf(NumberUtils.toLong((String)value))) : (isDouble ? property.lessThan(Double.valueOf(NumberUtils.toDouble((String)value))) : property.lexicalBefore(value));
                                break block0;
                            }
                            case LESS_OR_EQUALS: {
                                condition = isLong ? property.lessOrEqualTo(Long.valueOf(NumberUtils.toLong((String)value))) : (isDouble ? property.lessOrEqualTo(Double.valueOf(NumberUtils.toDouble((String)value))) : property.lexicalNotAfter(value));
                                break block0;
                            }
                            case GREATER_THAN: {
                                condition = isLong ? property.greaterThan(Long.valueOf(NumberUtils.toLong((String)value))) : (isDouble ? property.greaterThan(Double.valueOf(NumberUtils.toDouble((String)value))) : property.lexicalAfter(value));
                                break block0;
                            }
                            case GREATER_OR_EQUALS: {
                                condition = isLong ? property.greaterOrEqualTo(Long.valueOf(NumberUtils.toLong((String)value))) : (isDouble ? property.greaterOrEqualTo(Double.valueOf(NumberUtils.toDouble((String)value))) : property.lexicalNotBefore(value));
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = isLong ? property.notEqualTo(Long.valueOf(NumberUtils.toLong((String)value))) : (isDouble ? property.notEqualTo(Double.valueOf(NumberUtils.toDouble((String)value))) : (isBoolean ? property.notEqualTo(BooleanUtils.toStringTrueFalse((boolean)BooleanUtils.toBoolean((String)value))) : property.notEqualTolIgnoreCase(value)));
                                break block0;
                            }
                            case EQUALS: {
                                condition = isLong ? property.equalTo(Long.valueOf(NumberUtils.toLong((String)value)), new Long[0]) : (isDouble ? property.equalTo(Double.valueOf(NumberUtils.toDouble((String)value)), new Double[0]) : (isBoolean ? property.equalTo(BooleanUtils.toStringTrueFalse((boolean)BooleanUtils.toBoolean((String)value)), new String[0]) : property.equalToIgnoreCase(value, new String[0])));
                                break block0;
                            }
                        }
                        condition = property.equalToIgnoreCase(value, new String[0]);
                        break;
                    }
                    case ROLE_MEMBERSHIP: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty()) || !(builder instanceof UserFiqlSearchConditionBuilder)) break;
                        switch (clause.getComparator()) {
                            case EQUALS: {
                                condition = ((UserFiqlSearchConditionBuilder)builder).inRoles(clause.getProperty(), new String[0]);
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = ((UserFiqlSearchConditionBuilder)builder).notInRoles(clause.getProperty(), new String[0]);
                                break block0;
                            }
                        }
                        break;
                    }
                    case RELATIONSHIP: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        if (builder instanceof UserFiqlSearchConditionBuilder) {
                            UserFiqlSearchConditionBuilder ubuilder = (UserFiqlSearchConditionBuilder)builder;
                            switch (clause.getComparator()) {
                                case IS_NOT_NULL: {
                                    condition = ubuilder.inRelationshipTypes(clause.getProperty(), new String[0]);
                                    break block0;
                                }
                                case IS_NULL: {
                                    condition = ubuilder.notInRelationshipTypes(clause.getProperty(), new String[0]);
                                    break block0;
                                }
                                case EQUALS: {
                                    condition = ubuilder.inRelationships(value, new String[0]);
                                    break block0;
                                }
                                case NOT_EQUALS: {
                                    condition = ubuilder.notInRelationships(value, new String[0]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        switch (clause.getComparator()) {
                            case IS_NOT_NULL: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).inRelationshipTypes(clause.getProperty(), new String[0]);
                                break block0;
                            }
                            case IS_NULL: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).notInRelationshipTypes(clause.getProperty(), new String[0]);
                                break block0;
                            }
                            case EQUALS: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).inRelationships(value, new String[0]);
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).notInRelationships(value, new String[0]);
                                break block0;
                            }
                        }
                        break;
                    }
                    case CUSTOM: {
                        condition = customCondition.apply(clause);
                        break;
                    }
                }
            }
            if (notTheFirst) {
                if (clause.getOperator() == SearchClause.Operator.AND) {
                    condition = builder.and(condition, prevCondition, new CompleteCondition[0]);
                }
                if (clause.getOperator() == SearchClause.Operator.OR) {
                    condition = builder.or(condition, prevCondition, new CompleteCondition[0]);
                }
            }
            notTheFirst = true;
        }
        String fiql = condition == null ? null : condition.query();
        LOG.debug("Generated FIQL: {}", (Object)fiql);
        return fiql;
    }

    private SearchUtils() {
    }
}

