/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.wizards.any.AnyObjectWrapper;
import org.apache.syncope.client.console.wizards.any.ConsoleAuxClasses;
import org.apache.syncope.client.console.wizards.any.DerAttrs;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.DynamicMemberships;
import org.apache.syncope.client.console.wizards.any.GroupWizardBuilder;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.console.wizards.any.Groups;
import org.apache.syncope.client.console.wizards.any.Ownership;
import org.apache.syncope.client.console.wizards.any.PlainAttrs;
import org.apache.syncope.client.console.wizards.any.Relationships;
import org.apache.syncope.client.console.wizards.any.Roles;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.client.ui.commons.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractAnyWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.any.AnyForm;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;

public abstract class AnyWizardBuilder<A extends AnyTO>
extends AbstractAnyWizardBuilder<A> {
    private static final long serialVersionUID = -2480279868319546243L;
    protected final List<String> anyTypeClasses;
    protected AbstractAnyFormLayout<A, ? extends AnyForm<A>> formLayoutInfo;

    protected static <T extends AnyTO> AnyWrapper<T> wrapper(T anyTO) {
        Object object;
        if (anyTO instanceof UserTO) {
            UserTO userTO = (UserTO)anyTO;
            object = new UserWrapper(userTO);
        } else if (anyTO instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)anyTO;
            object = new GroupWrapper(groupTO);
        } else {
            object = new AnyObjectWrapper((AnyObjectTO)anyTO);
        }
        return object;
    }

    public AnyWizardBuilder(A anyTO, List<String> anyTypeClasses, AbstractAnyFormLayout<A, ? extends AnyForm<A>> formLayoutInfo, PageReference pageRef) {
        super(AnyWizardBuilder.wrapper(anyTO), pageRef);
        this.anyTypeClasses = anyTypeClasses;
        this.formLayoutInfo = formLayoutInfo;
    }

    public AnyWizardBuilder(AnyWrapper<A> wrapper, List<String> anyTypeClasses, AbstractAnyFormLayout<A, ? extends AnyForm<A>> formLayoutInfo, PageReference pageRef) {
        super(wrapper, pageRef);
        this.anyTypeClasses = anyTypeClasses;
        this.formLayoutInfo = formLayoutInfo;
    }

    protected WizardModel buildModelSteps(AnyWrapper<A> modelObject, WizardModel wizardModel) {
        this.addOptionalDetailsPanel(modelObject).ifPresent(arg_0 -> ((WizardModel)wizardModel).add(arg_0));
        if (this instanceof GroupWizardBuilder && modelObject.getInnerObject() instanceof GroupTO && this.formLayoutInfo instanceof GroupFormLayoutInfo) {
            GroupFormLayoutInfo groupFormLayoutInfo = (GroupFormLayoutInfo)((Object)GroupFormLayoutInfo.class.cast(this.formLayoutInfo));
            if (groupFormLayoutInfo.isOwnership()) {
                wizardModel.add((IWizardStep)new Ownership((GroupWrapper)((Object)GroupWrapper.class.cast(modelObject)), this.pageRef));
            }
            if (groupFormLayoutInfo.isDynamicMemberships()) {
                wizardModel.add((IWizardStep)new DynamicMemberships((GroupWrapper)((Object)GroupWrapper.class.cast(modelObject)), this.pageRef));
            }
        }
        if (this.formLayoutInfo.isAuxClasses()) {
            wizardModel.add((IWizardStep)new ConsoleAuxClasses(modelObject, this.anyTypeClasses));
        }
        if (this.formLayoutInfo.isGroups()) {
            wizardModel.add((IWizardStep)new Groups(modelObject, this.mode == AjaxWizard.Mode.TEMPLATE));
        }
        if (this.formLayoutInfo.isPlainAttrs()) {
            wizardModel.add((IWizardStep)new PlainAttrs(modelObject, this.mode, this.anyTypeClasses, this.formLayoutInfo.getWhichPlainAttrs()){
                private static final long serialVersionUID = 8167894751609598306L;

                @Override
                public PageReference getPageReference() {
                    return AnyWizardBuilder.this.pageRef;
                }
            });
        }
        if (this.formLayoutInfo.isDerAttrs() && this.mode != AjaxWizard.Mode.TEMPLATE) {
            wizardModel.add((IWizardStep)new DerAttrs(modelObject, this.anyTypeClasses, this.formLayoutInfo.getWhichDerAttrs()));
        }
        if (this instanceof UserWizardBuilder && modelObject instanceof UserWrapper) {
            UserWrapper userWrapper = (UserWrapper)modelObject;
            if (this.formLayoutInfo instanceof UserFormLayoutInfo && ((UserFormLayoutInfo)((Object)UserFormLayoutInfo.class.cast(this.formLayoutInfo))).isRoles()) {
                wizardModel.add((IWizardStep)new Roles(userWrapper));
            }
        }
        if (this.formLayoutInfo instanceof UserFormLayoutInfo && ((UserFormLayoutInfo)((Object)UserFormLayoutInfo.class.cast(this.formLayoutInfo))).isRelationships() || this.formLayoutInfo instanceof AnyObjectFormLayoutInfo && ((AnyObjectFormLayoutInfo)((Object)AnyObjectFormLayoutInfo.class.cast(this.formLayoutInfo))).isRelationships()) {
            wizardModel.add((IWizardStep)new Relationships(modelObject, this.pageRef));
        }
        SyncopeWebApplication.get().getAnyWizardBuilderAdditionalSteps().buildModelSteps(modelObject, wizardModel, this.formLayoutInfo);
        return wizardModel;
    }

    protected Optional<Details<A>> addOptionalDetailsPanel(AnyWrapper<A> modelObject) {
        if (((AnyTO)modelObject.getInnerObject()).getKey() == null) {
            return Optional.empty();
        }
        return Optional.of(new Details<A>(modelObject, this.mode == AjaxWizard.Mode.TEMPLATE, true, this.pageRef));
    }

    protected void fixPlainAttrs(AnyTO updated, AnyTO original) {
        GroupableRelatableTO updatedTO;
        for (Attr plainAttr : original.getPlainAttrs()) {
            if (!updated.getPlainAttr(plainAttr.getSchema()).isEmpty()) continue;
            updated.getPlainAttrs().add(plainAttr);
        }
        if (updated instanceof GroupableRelatableTO) {
            updatedTO = (GroupableRelatableTO)updated;
            if (original instanceof GroupableRelatableTO) {
                GroupableRelatableTO originalTO = (GroupableRelatableTO)original;
                originalTO.getMemberships().forEach(oMemb -> updatedTO.getMembership(oMemb.getGroupKey()).ifPresent(uMemb -> oMemb.getPlainAttrs().stream().filter(attr -> uMemb.getPlainAttr(attr.getSchema()).isEmpty()).forEach(attr -> uMemb.getPlainAttrs().add(attr))));
            }
        }
        updated.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty());
        if (updated instanceof GroupableRelatableTO) {
            updatedTO = (GroupableRelatableTO)updated;
            updatedTO.getMemberships().forEach(memb -> memb.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty()));
        }
    }

    protected long getMaxWaitTimeInSeconds() {
        return SyncopeWebApplication.get().getMaxWaitTimeInSeconds();
    }

    protected void sendError(Exception exception) {
        SyncopeConsoleSession.get().onException(exception);
    }

    protected void sendWarning(String message) {
        SyncopeConsoleSession.get().warn((Serializable)((Object)message));
    }

    protected Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> future) {
        return SyncopeConsoleSession.get().execute(future);
    }
}

