/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultPartitionerTest {
    private static final byte[] KEY_BYTES = "key".getBytes();
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(12, "localhost", 101)};
    private static final String TOPIC = "test";
    private static final List<PartitionInfo> PARTITIONS = Arrays.asList(new PartitionInfo("test", 1, null, NODES, NODES), new PartitionInfo("test", 2, NODES[1], NODES, NODES), new PartitionInfo("test", 0, NODES[0], NODES, NODES));

    @Test
    public void testKeyPartitionIsStable() {
        DefaultPartitioner partitioner = new DefaultPartitioner();
        Cluster cluster = new Cluster("clusterId", Arrays.asList(NODES), PARTITIONS, Collections.emptySet(), Collections.emptySet());
        int partition = partitioner.partition(TOPIC, null, KEY_BYTES, null, null, cluster);
        Assertions.assertEquals((int)partition, (int)partitioner.partition(TOPIC, null, KEY_BYTES, null, null, cluster), (String)"Same key should yield same partition");
    }
}

