/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicPartitionTest {
    private final String topicName = "mytopic";
    private final int partNum = 5;

    private void checkValues(TopicPartition deSerTP) {
        Assertions.assertEquals((int)5, (int)deSerTP.partition(), (String)("partition number should be 5 but got " + deSerTP.partition()));
        Assertions.assertEquals((Object)"mytopic", (Object)deSerTP.topic(), (String)("topic should be mytopic but got " + deSerTP.topic()));
    }

    @Test
    public void testSerializationRoundtrip() throws IOException, ClassNotFoundException {
        TopicPartition origTp = new TopicPartition("mytopic", 5);
        byte[] byteArray = Serializer.serialize(origTp);
        Object deserializedObject = Serializer.deserialize(byteArray);
        Assertions.assertInstanceOf(TopicPartition.class, (Object)deserializedObject);
        this.checkValues((TopicPartition)deserializedObject);
    }

    @Test
    public void testTopiPartitionSerializationCompatibility() throws IOException, ClassNotFoundException {
        Object deserializedObject = Serializer.deserialize("serializedData/topicPartitionSerializedfile");
        Assertions.assertInstanceOf(TopicPartition.class, (Object)deserializedObject);
        this.checkValues((TopicPartition)deserializedObject);
    }
}

