/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class KafkaChannelTest {
    @Test
    public void testSending() throws IOException {
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        TransportLayer transport = (TransportLayer)Mockito.mock(TransportLayer.class);
        MemoryPool pool = (MemoryPool)Mockito.mock(MemoryPool.class);
        ChannelMetadataRegistry metadataRegistry = (ChannelMetadataRegistry)Mockito.mock(ChannelMetadataRegistry.class);
        KafkaChannel channel = new KafkaChannel("0", transport, () -> authenticator, 1024, pool, metadataRegistry);
        ByteBufferSend send = ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(TestUtils.randomBytes(128)));
        NetworkSend networkSend = new NetworkSend("0", (Send)send);
        channel.setSend(networkSend);
        Assertions.assertTrue((boolean)channel.hasSend());
        Assertions.assertThrows(IllegalStateException.class, () -> channel.setSend(networkSend));
        Mockito.when((Object)transport.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)4L);
        Assertions.assertEquals((long)4L, (long)channel.write());
        Assertions.assertEquals((long)128L, (long)send.remaining());
        Assertions.assertNull((Object)channel.maybeCompleteSend());
        Mockito.when((Object)transport.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)64L);
        Assertions.assertEquals((long)64L, (long)channel.write());
        Assertions.assertEquals((long)64L, (long)send.remaining());
        Assertions.assertNull((Object)channel.maybeCompleteSend());
        Mockito.when((Object)transport.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)64L);
        Assertions.assertEquals((long)64L, (long)channel.write());
        Assertions.assertEquals((long)0L, (long)send.remaining());
        Assertions.assertEquals((Object)networkSend, (Object)channel.maybeCompleteSend());
    }

    @Test
    public void testReceiving() throws IOException {
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        TransportLayer transport = (TransportLayer)Mockito.mock(TransportLayer.class);
        MemoryPool pool = (MemoryPool)Mockito.mock(MemoryPool.class);
        ChannelMetadataRegistry metadataRegistry = (ChannelMetadataRegistry)Mockito.mock(ChannelMetadataRegistry.class);
        ArgumentCaptor sizeCaptor = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)pool.tryAllocate(((Integer)sizeCaptor.capture()).intValue())).thenAnswer(invocation -> ByteBuffer.allocate((Integer)sizeCaptor.getValue()));
        KafkaChannel channel = new KafkaChannel("0", transport, () -> authenticator, 1024, pool, metadataRegistry);
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)transport.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(128);
            return 4;
        }).thenReturn((Object)0);
        Assertions.assertEquals((long)4L, (long)channel.read());
        Assertions.assertEquals((int)4, (int)channel.currentReceive().bytesRead());
        Assertions.assertNull((Object)channel.maybeCompleteReceive());
        Mockito.reset((Object[])new TransportLayer[]{transport});
        Mockito.when((Object)transport.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assertions.assertEquals((long)64L, (long)channel.read());
        Assertions.assertEquals((int)68, (int)channel.currentReceive().bytesRead());
        Assertions.assertNull((Object)channel.maybeCompleteReceive());
        Mockito.reset((Object[])new TransportLayer[]{transport});
        Mockito.when((Object)transport.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assertions.assertEquals((long)64L, (long)channel.read());
        Assertions.assertEquals((int)132, (int)channel.currentReceive().bytesRead());
        Assertions.assertNotNull((Object)channel.maybeCompleteReceive());
        Assertions.assertNull((Object)channel.currentReceive());
    }
}

