/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SendBuilder;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SendBuilderTest {
    @Test
    public void testZeroCopyByteBuffer() {
        byte[] data = Utils.utf8((String)"foo");
        ByteBuffer zeroCopyBuffer = ByteBuffer.wrap(data);
        SendBuilder builder = new SendBuilder(8);
        builder.writeInt(5);
        builder.writeByteBuffer(zeroCopyBuffer);
        builder.writeInt(15);
        Send send = builder.build();
        byte[] overwrittenData = Utils.utf8((String)"bar");
        Assertions.assertEquals((int)data.length, (int)overwrittenData.length);
        zeroCopyBuffer.rewind();
        zeroCopyBuffer.put(overwrittenData);
        zeroCopyBuffer.rewind();
        ByteBuffer buffer = TestUtils.toBuffer(send);
        Assertions.assertEquals((int)(8 + data.length), (int)buffer.remaining());
        Assertions.assertEquals((int)5, (int)buffer.getInt());
        Assertions.assertEquals((Object)"bar", (Object)this.getString(buffer, data.length));
        Assertions.assertEquals((int)15, (int)buffer.getInt());
    }

    @Test
    public void testWriteByteBufferRespectsPosition() {
        byte[] data = Utils.utf8((String)"yolo");
        Assertions.assertEquals((int)4, (int)data.length);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        SendBuilder builder = new SendBuilder(0);
        buffer.limit(2);
        builder.writeByteBuffer(buffer);
        Assertions.assertEquals((int)0, (int)buffer.position());
        buffer.position(2);
        buffer.limit(4);
        builder.writeByteBuffer(buffer);
        Assertions.assertEquals((int)2, (int)buffer.position());
        Send send = builder.build();
        ByteBuffer readBuffer = TestUtils.toBuffer(send);
        Assertions.assertEquals((Object)"yolo", (Object)this.getString(readBuffer, 4));
    }

    @Test
    public void testZeroCopyRecords() {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        MemoryRecords records = this.createRecords(buffer, "foo");
        SendBuilder builder = new SendBuilder(8);
        builder.writeInt(5);
        builder.writeRecords((BaseRecords)records);
        builder.writeInt(15);
        Send send = builder.build();
        buffer.rewind();
        MemoryRecords overwrittenRecords = this.createRecords(buffer, "bar");
        ByteBuffer readBuffer = TestUtils.toBuffer(send);
        Assertions.assertEquals((int)5, (int)readBuffer.getInt());
        Assertions.assertEquals((Object)overwrittenRecords, (Object)this.getRecords(readBuffer, records.sizeInBytes()));
        Assertions.assertEquals((int)15, (int)readBuffer.getInt());
    }

    @Test
    public void testZeroCopyUnalignedRecords() {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        MemoryRecords records = this.createRecords(buffer, "foo");
        ByteBuffer buffer1 = records.buffer().duplicate();
        buffer1.limit(buffer1.limit() / 2);
        ByteBuffer buffer2 = records.buffer().duplicate();
        buffer2.position(buffer2.limit() / 2);
        UnalignedMemoryRecords records1 = new UnalignedMemoryRecords(buffer1);
        UnalignedMemoryRecords records2 = new UnalignedMemoryRecords(buffer2);
        SendBuilder builder = new SendBuilder(8);
        builder.writeInt(5);
        builder.writeRecords((BaseRecords)records1);
        builder.writeRecords((BaseRecords)records2);
        builder.writeInt(15);
        Send send = builder.build();
        buffer.rewind();
        MemoryRecords overwrittenRecords = this.createRecords(buffer, "bar");
        ByteBuffer readBuffer = TestUtils.toBuffer(send);
        Assertions.assertEquals((int)5, (int)readBuffer.getInt());
        Assertions.assertEquals((Object)overwrittenRecords, (Object)this.getRecords(readBuffer, records.sizeInBytes()));
        Assertions.assertEquals((int)15, (int)readBuffer.getInt());
    }

    private String getString(ByteBuffer buffer, int size) {
        byte[] readData = new byte[size];
        buffer.get(readData);
        return Utils.utf8((byte[])readData);
    }

    private MemoryRecords getRecords(ByteBuffer buffer, int size) {
        int initialPosition = buffer.position();
        int initialLimit = buffer.limit();
        int recordsLimit = initialPosition + size;
        buffer.limit(recordsLimit);
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer.slice());
        buffer.position(recordsLimit);
        buffer.limit(initialLimit);
        return records;
    }

    private MemoryRecords createRecords(ByteBuffer buffer, String value) {
        MemoryRecordsBuilder recordsBuilder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        recordsBuilder.append(new SimpleRecord(Utils.utf8((String)value)));
        return recordsBuilder.build();
    }
}

