/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StopReplicaResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        ArrayList<StopReplicaRequestData.StopReplicaTopicState> topicStates = new ArrayList<StopReplicaRequestData.StopReplicaTopicState>();
        topicStates.add(new StopReplicaRequestData.StopReplicaTopicState().setTopicName("foo").setPartitionStates(Arrays.asList(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0), new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(1))));
        Iterator iterator = ApiKeys.STOP_REPLICA.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            StopReplicaRequest request = new StopReplicaRequest.Builder(version, 15, 20, 0L, false, topicStates).build(version);
            StopReplicaResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
            Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 3), (Object)response.errorCounts());
        }
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setPartitionErrors(errors));
        Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 3), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(errors));
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)2, (int)errorCounts.size());
        Assertions.assertEquals((int)2, (int)((Integer)errorCounts.get(Errors.NONE)));
        Assertions.assertEquals((int)1, (int)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)));
    }

    @Test
    public void testToString() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setPartitionErrors(errors));
        String responseStr = response.toString();
        Assertions.assertTrue((boolean)responseStr.contains(StopReplicaResponse.class.getSimpleName()));
        Assertions.assertTrue((boolean)responseStr.contains(((Object)errors).toString()));
        Assertions.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
    }
}

