/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class ImplicitLinkedHashCollectionTest {
    @Test
    public void testNullForbidden() {
        ImplicitLinkedHashMultiCollection multiColl = new ImplicitLinkedHashMultiCollection();
        Assertions.assertFalse((boolean)multiColl.add(null));
    }

    @Test
    public void testInsertDelete() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection(100);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1)));
        TestElement second = new TestElement(2);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)second));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3)));
        Assertions.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3)));
        Assertions.assertEquals((int)3, (int)coll.size());
        Assertions.assertTrue((boolean)coll.contains((Object)new TestElement(1)));
        Assertions.assertFalse((boolean)coll.contains((Object)new TestElement(4)));
        TestElement secondAgain = (TestElement)coll.find((ImplicitLinkedHashCollection.Element)new TestElement(2));
        Assertions.assertSame((Object)second, (Object)secondAgain);
        Assertions.assertTrue((boolean)coll.remove((Object)new TestElement(1)));
        Assertions.assertFalse((boolean)coll.remove((Object)new TestElement(1)));
        Assertions.assertEquals((int)2, (int)coll.size());
        coll.clear();
        Assertions.assertEquals((int)0, (int)coll.size());
    }

    static void expectTraversal(Iterator<TestElement> iterator, Integer ... sequence) {
        int i = 0;
        while (iterator.hasNext()) {
            TestElement element = iterator.next();
            Assertions.assertTrue((i < sequence.length ? 1 : 0) != 0, (String)("Iterator yieled " + (i + 1) + " elements, but only " + sequence.length + " were expected."));
            Assertions.assertEquals((int)sequence[i], (int)element.key, (String)("Iterator value number " + (i + 1) + " was incorrect."));
            ++i;
        }
        Assertions.assertEquals((int)sequence.length, (int)i, (String)("Iterator yieled " + (i + 1) + " elements, but " + sequence.length + " were expected."));
    }

    static void expectTraversal(Iterator<TestElement> iter, Iterator<Integer> expectedIter) {
        int i = 0;
        while (iter.hasNext()) {
            TestElement element = iter.next();
            Assertions.assertTrue((boolean)expectedIter.hasNext(), (String)("Iterator yieled " + (i + 1) + " elements, but only " + i + " were expected."));
            Integer expected = expectedIter.next();
            Assertions.assertEquals((int)expected, (int)element.key, (String)("Iterator value number " + (i + 1) + " was incorrect."));
            ++i;
        }
        Assertions.assertFalse((boolean)expectedIter.hasNext(), (String)("Iterator yieled " + i + " elements, but at least " + (i + 1) + " were expected."));
    }

    @Test
    public void testTraversal() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), new Integer[0]);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 1);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(100)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 1, 100);
        Assertions.assertTrue((boolean)coll.remove((Object)new TestElement(1)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 100);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 100, 1);
        Iterator iter = coll.iterator();
        iter.next();
        iter.next();
        iter.remove();
        iter.next();
        Assertions.assertFalse((boolean)iter.hasNext());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 1);
        ArrayList<TestElement> list = new ArrayList<TestElement>();
        list.add(new TestElement(1));
        list.add(new TestElement(2));
        Assertions.assertTrue((boolean)coll.removeAll(list));
        Assertions.assertFalse((boolean)coll.removeAll(list));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), new Integer[0]);
        Assertions.assertEquals((int)0, (int)coll.size());
        Assertions.assertTrue((boolean)coll.isEmpty());
    }

    @Test
    public void testSetViewGet() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        Set set = coll.valuesSet();
        Assertions.assertTrue((boolean)set.contains(new TestElement(1)));
        Assertions.assertTrue((boolean)set.contains(new TestElement(2)));
        Assertions.assertTrue((boolean)set.contains(new TestElement(3)));
        Assertions.assertEquals((int)3, (int)set.size());
    }

    @Test
    public void testSetViewModification() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        Set set = coll.valuesSet();
        set.remove(new TestElement(1));
        Assertions.assertFalse((boolean)coll.contains((Object)new TestElement(1)));
        Assertions.assertEquals((int)2, (int)coll.size());
        set.add(new TestElement(4));
        Assertions.assertTrue((boolean)coll.contains((Object)new TestElement(4)));
        Assertions.assertEquals((int)3, (int)coll.size());
        coll.remove((Object)new TestElement(2));
        Assertions.assertFalse((boolean)set.contains(new TestElement(2)));
        Assertions.assertEquals((int)2, (int)set.size());
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(5));
        Assertions.assertTrue((boolean)set.contains(new TestElement(5)));
        Assertions.assertEquals((int)3, (int)set.size());
        int key = 3;
        for (TestElement e : coll) {
            Assertions.assertEquals((int)key, (int)e.key);
            ++key;
        }
    }

    @Test
    public void testListViewGet() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        List list = coll.valuesList();
        Assertions.assertEquals((int)1, (int)((TestElement)list.get(0)).key);
        Assertions.assertEquals((int)2, (int)((TestElement)list.get(1)).key);
        Assertions.assertEquals((int)3, (int)((TestElement)list.get(2)).key);
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testListViewModification() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        List list = coll.valuesList();
        list.remove(1);
        Assertions.assertTrue((boolean)coll.contains((Object)new TestElement(1)));
        Assertions.assertFalse((boolean)coll.contains((Object)new TestElement(2)));
        Assertions.assertTrue((boolean)coll.contains((Object)new TestElement(3)));
        Assertions.assertEquals((int)2, (int)coll.size());
        coll.remove((Object)new TestElement(1));
        Assertions.assertEquals((int)3, (int)((TestElement)list.get(0)).key);
        Assertions.assertEquals((int)1, (int)list.size());
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(4));
        Assertions.assertEquals((int)3, (int)((TestElement)list.get(0)).key);
        Assertions.assertEquals((int)4, (int)((TestElement)list.get(1)).key);
        Assertions.assertEquals((int)2, (int)list.size());
    }

    @Test
    public void testEmptyListIterator() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        ListIterator iter = coll.valuesList().listIterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertFalse((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
    }

    @Test
    public void testListIteratorCreation() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ListIterator iter = coll.valuesList().listIterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertFalse((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        iter = coll.valuesList().listIterator(2);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        iter = coll.valuesList().listIterator(3);
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)3, (int)iter.nextIndex());
        Assertions.assertEquals((int)2, (int)iter.previousIndex());
    }

    @Test
    public void testListIteratorTraversal() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ListIterator iter = coll.valuesList().listIterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertFalse((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)((TestElement)iter.next()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)((TestElement)iter.next()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        Assertions.assertEquals((int)3, (int)((TestElement)iter.next()).key);
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)3, (int)iter.nextIndex());
        Assertions.assertEquals((int)2, (int)iter.previousIndex());
        Assertions.assertEquals((int)3, (int)((TestElement)iter.previous()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)((TestElement)iter.previous()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)((TestElement)iter.next()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        Assertions.assertEquals((int)2, (int)((TestElement)iter.previous()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)((TestElement)iter.previous()).key);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertFalse((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
    }

    @Test
    public void testListIteratorRemove() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(4));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(5));
        ListIterator iter = coll.valuesList().listIterator();
        try {
            iter.remove();
            Assertions.fail((String)"Calling remove() without calling next() or previous() should raise an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        iter.next();
        iter.next();
        iter.next();
        iter.remove();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)2, (int)iter.nextIndex());
        Assertions.assertEquals((int)1, (int)iter.previousIndex());
        try {
            iter.remove();
            Assertions.fail((String)"Calling remove() twice without calling next() or previous() in between should raise an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)((TestElement)iter.previous()).key);
        iter.remove();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)1, (int)((TestElement)iter.previous()).key);
        iter.remove();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertFalse((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
        Assertions.assertEquals((int)4, (int)((TestElement)iter.next()).key);
        Assertions.assertEquals((int)5, (int)((TestElement)iter.next()).key);
        iter.remove();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)1, (int)iter.nextIndex());
        Assertions.assertEquals((int)0, (int)iter.previousIndex());
        Assertions.assertEquals((int)4, (int)((TestElement)iter.previous()).key);
        iter.remove();
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertFalse((boolean)iter.hasPrevious());
        Assertions.assertEquals((int)0, (int)iter.nextIndex());
        Assertions.assertEquals((int)-1, (int)iter.previousIndex());
    }

    @Test
    public void testCollisions() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection(5);
        Assertions.assertEquals((int)11, (int)coll.numSlots());
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(11)));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(0)));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(22)));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(33)));
        Assertions.assertEquals((int)11, (int)coll.numSlots());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 11, 0, 22, 33);
        Assertions.assertTrue((boolean)coll.remove((Object)new TestElement(22)));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 11, 0, 33);
        Assertions.assertEquals((int)3, (int)coll.size());
        Assertions.assertFalse((boolean)coll.isEmpty());
    }

    @Test
    public void testEnlargement() {
        int i;
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection(5);
        Assertions.assertEquals((int)11, (int)coll.numSlots());
        for (i = 0; i < 6; ++i) {
            Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(i)));
        }
        Assertions.assertEquals((int)23, (int)coll.numSlots());
        Assertions.assertEquals((int)6, (int)coll.size());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 0, 1, 2, 3, 4, 5);
        for (i = 0; i < 6; ++i) {
            Assertions.assertTrue((boolean)coll.contains((Object)new TestElement(i)), (String)("Failed to find element " + i));
        }
        coll.remove((Object)new TestElement(3));
        Assertions.assertEquals((int)23, (int)coll.numSlots());
        Assertions.assertEquals((int)5, (int)coll.size());
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 0, 1, 2, 4, 5);
    }

    @Test
    public void testManyInsertsAndDeletes() {
        Random random = new Random(123L);
        LinkedHashSet<Integer> existing = new LinkedHashSet<Integer>();
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        for (int i = 0; i < 100; ++i) {
            this.addRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            this.addRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            this.addRandomElement(random, existing, (ImplicitLinkedHashCollection<TestElement>)coll);
            this.removeRandomElement(random, existing);
            ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), existing.iterator());
        }
    }

    @Test
    public void testInsertingTheSameObjectMultipleTimes() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        TestElement element = new TestElement(123);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assertions.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assertions.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assertions.assertTrue((boolean)coll.remove((Object)element));
        Assertions.assertFalse((boolean)coll.remove((Object)element));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
        Assertions.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)element));
    }

    @Test
    public void testEquals() {
        ImplicitLinkedHashCollection coll1 = new ImplicitLinkedHashCollection();
        coll1.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll1.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll1.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ImplicitLinkedHashCollection coll2 = new ImplicitLinkedHashCollection();
        coll2.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll2.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        coll2.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        ImplicitLinkedHashCollection coll3 = new ImplicitLinkedHashCollection();
        coll3.add((ImplicitLinkedHashCollection.Element)new TestElement(1));
        coll3.add((ImplicitLinkedHashCollection.Element)new TestElement(3));
        coll3.add((ImplicitLinkedHashCollection.Element)new TestElement(2));
        Assertions.assertEquals((Object)coll1, (Object)coll2);
        Assertions.assertNotEquals((Object)coll1, (Object)coll3);
        Assertions.assertNotEquals((Object)coll2, (Object)coll3);
    }

    @Test
    public void testFindContainsRemoveOnEmptyCollection() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        Assertions.assertNull((Object)coll.find((ImplicitLinkedHashCollection.Element)new TestElement(2)));
        Assertions.assertFalse((boolean)coll.contains((Object)new TestElement(2)));
        Assertions.assertFalse((boolean)coll.remove((Object)new TestElement(2)));
    }

    private void addRandomElement(Random random, LinkedHashSet<Integer> existing, ImplicitLinkedHashCollection<TestElement> set) {
        int next;
        while (existing.contains(next = random.nextInt())) {
        }
        existing.add(next);
        set.add((ImplicitLinkedHashCollection.Element)new TestElement(next));
    }

    private void removeRandomElement(Random random, Collection<Integer> existing) {
        int removeIdx = random.nextInt(existing.size());
        Iterator<Integer> iter = existing.iterator();
        Integer element = null;
        for (int i = 0; i <= removeIdx; ++i) {
            element = iter.next();
        }
        existing.remove(new TestElement(element));
    }

    @Test
    public void testSameKeysDifferentValues() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1, 1)));
        Assertions.assertFalse((boolean)coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1, 2)));
        TestElement element2 = new TestElement(1, 2);
        TestElement element1 = (TestElement)coll.find((ImplicitLinkedHashCollection.Element)element2);
        Assertions.assertNotEquals((Object)element2, (Object)element1);
        Assertions.assertTrue((boolean)element2.elementKeysAreEqual(element1));
    }

    @Test
    public void testMoveToEnd() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        TestElement e1 = new TestElement(1, 1);
        TestElement e2 = new TestElement(2, 2);
        TestElement e3 = new TestElement(3, 3);
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)e1));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)e2));
        Assertions.assertTrue((boolean)coll.add((ImplicitLinkedHashCollection.Element)e3));
        coll.moveToEnd((ImplicitLinkedHashCollection.Element)e1);
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 2, 3, 1);
        Assertions.assertThrows(RuntimeException.class, () -> coll.moveToEnd((ImplicitLinkedHashCollection.Element)new TestElement(4, 4)));
    }

    @Test
    public void testRemovals() {
        int i;
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        ArrayList<TestElement> elements = new ArrayList<TestElement>();
        for (int i2 = 0; i2 < 100; ++i2) {
            TestElement element = new TestElement(i2, i2);
            elements.add(element);
            coll.add((ImplicitLinkedHashCollection.Element)element);
        }
        Assertions.assertEquals((int)100, (int)coll.size());
        Iterator iter = coll.iterator();
        for (i = 0; i < 50; ++i) {
            iter.next();
            iter.remove();
        }
        Assertions.assertEquals((int)50, (int)coll.size());
        for (i = 50; i < 100; ++i) {
            Assertions.assertEquals((Object)new TestElement(i, i), (Object)coll.find((ImplicitLinkedHashCollection.Element)elements.get(i)));
        }
    }

    @Test
    public void testSort() {
        ImplicitLinkedHashCollection coll = new ImplicitLinkedHashCollection();
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(3, 3));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(1, 1));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(10, 10));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(9, 9));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(2, 2));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(4, 4));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(0, 0));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(30, 30));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(20, 20));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(11, 11));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(15, 15));
        coll.add((ImplicitLinkedHashCollection.Element)new TestElement(5, 5));
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 3, 1, 10, 9, 2, 4, 0, 30, 20, 11, 15, 5);
        coll.sort((Comparator)TestElementComparator.INSTANCE);
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 0, 1, 2, 3, 4, 5, 9, 10, 11, 15, 20, 30);
        coll.sort((Comparator)TestElementComparator.INSTANCE);
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 0, 1, 2, 3, 4, 5, 9, 10, 11, 15, 20, 30);
        coll.sort((Comparator)ReverseTestElementComparator.INSTANCE);
        ImplicitLinkedHashCollectionTest.expectTraversal((Iterator<TestElement>)coll.iterator(), 30, 20, 15, 11, 10, 9, 5, 4, 3, 2, 1, 0);
    }

    static class ReverseTestElementComparator
    implements Comparator<TestElement> {
        static final ReverseTestElementComparator INSTANCE = new ReverseTestElementComparator();

        ReverseTestElementComparator() {
        }

        @Override
        public int compare(TestElement a, TestElement b) {
            return TestElementComparator.INSTANCE.compare(b, a);
        }
    }

    static class TestElementComparator
    implements Comparator<TestElement> {
        static final TestElementComparator INSTANCE = new TestElementComparator();

        TestElementComparator() {
        }

        @Override
        public int compare(TestElement a, TestElement b) {
            if (a.key < b.key) {
                return -1;
            }
            if (a.key > b.key) {
                return 1;
            }
            if (a.val < b.val) {
                return -1;
            }
            if (a.val > b.val) {
                return 1;
            }
            return 0;
        }
    }

    static final class TestElement
    implements ImplicitLinkedHashCollection.Element {
        private int prev = -2;
        private int next = -2;
        private final int key;
        private final int val;

        TestElement(int key) {
            this.key = key;
            this.val = 0;
        }

        TestElement(int key, int val) {
            this.key = key;
            this.val = val;
        }

        public int prev() {
            return this.prev;
        }

        public void setPrev(int prev) {
            this.prev = prev;
        }

        public int next() {
            return this.next;
        }

        public void setNext(int next) {
            this.next = next;
        }

        public boolean elementKeysAreEqual(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != TestElement.class) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.key == that.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != TestElement.class) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.key == that.key && this.val == that.val;
        }

        public String toString() {
            return "TestElement(key=" + this.key + ", val=" + this.val + ")";
        }

        public int hashCode() {
            long hashCode = 2654435761L * (long)this.key;
            return (int)(hashCode >> 32);
        }
    }
}

