/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.IOException;
import org.apache.kafka.common.utils.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@Timeout(value=180L)
@DisabledOnOs(value={OS.WINDOWS})
public class ShellTest {
    private static final String NONEXISTENT_PATH = "/dev/a/path/that/does/not/exist/in/the/filesystem";

    @Test
    public void testEchoHello() throws Exception {
        String output = Shell.execCommand((String[])new String[]{"echo", "hello"});
        Assertions.assertEquals((Object)"hello\n", (Object)output);
    }

    @Test
    public void testHeadDevZero() throws Exception {
        int length = 100000;
        String output = Shell.execCommand((String[])new String[]{"head", "-c", Integer.toString(100000), "/dev/zero"});
        Assertions.assertEquals((int)100000, (int)output.length());
    }

    @Test
    public void testAttemptToRunNonExistentProgram() {
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> Shell.execCommand((String[])new String[]{NONEXISTENT_PATH}), (String)"Expected to get an exception when trying to run a program that does not exist");
        Assertions.assertTrue((boolean)e.getMessage().contains("No such file"), (String)("Unexpected error message '" + e.getMessage() + "'"));
    }

    @Test
    public void testRunProgramWithErrorReturn() {
        Shell.ExitCodeException e = (Shell.ExitCodeException)Assertions.assertThrows(Shell.ExitCodeException.class, () -> Shell.execCommand((String[])new String[]{"head", "-c", "0", NONEXISTENT_PATH}));
        String message = e.getMessage();
        Assertions.assertTrue((message.contains("No such file") || message.contains("illegal byte count") ? 1 : 0) != 0, (String)("Unexpected error message '" + message + "'"));
    }
}

