/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractSwaggerWelcome {
    protected final SwaggerUiConfigProperties swaggerUiConfig;
    protected final SpringDocConfigProperties springDocConfigProperties;

    protected AbstractSwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    protected void init(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        this.springDocConfigProperties.getGroupConfigs().forEach(groupConfig -> swaggerUiConfigParameters.addGroup(groupConfig.getGroup(), groupConfig.getDisplayName()));
        this.calculateUiRootPath(swaggerUiConfigParameters, new StringBuilder[0]);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + (String)docsUrl;
        }
        if (!((String)docsUrl).startsWith("/")) {
            docsUrl = "/" + (String)docsUrl;
        }
        return contextPath + (String)docsUrl;
    }

    protected void buildConfigUrl(SwaggerUiConfigParameters swaggerUiConfigParameters, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isEmpty((CharSequence)this.swaggerUiConfig.getConfigUrl())) {
            this.buildApiDocUrl(swaggerUiConfigParameters);
            this.buildSwaggerConfigUrl(swaggerUiConfigParameters);
            if (CollectionUtils.isEmpty(swaggerUiConfigParameters.getUrls())) {
                String swaggerUiUrl = this.swaggerUiConfig.getUrl();
                if (StringUtils.isEmpty((CharSequence)swaggerUiUrl)) {
                    swaggerUiConfigParameters.setUrl(swaggerUiConfigParameters.getApiDocsUrl());
                } else if (swaggerUiConfigParameters.isValidUrl(swaggerUiUrl)) {
                    swaggerUiConfigParameters.setUrl(swaggerUiUrl);
                } else {
                    swaggerUiConfigParameters.setUrl(this.buildUrlWithContextPath(swaggerUiConfigParameters, swaggerUiUrl));
                }
            } else {
                swaggerUiConfigParameters.addUrl(swaggerUiConfigParameters.getApiDocsUrl());
            }
            if (!CollectionUtils.isEmpty(this.swaggerUiConfig.getUrls())) {
                this.swaggerUiConfig.cloneUrls().stream().filter(swaggerUrl -> !swaggerUiConfigParameters.isValidUrl(swaggerUrl.getUrl())).forEach(swaggerUrl -> {
                    String url = this.buildUrlWithContextPath(swaggerUiConfigParameters, swaggerUrl.getUrl());
                    if (!Objects.equals(url, swaggerUrl.getUrl())) {
                        swaggerUiConfigParameters.getUrls().stream().filter(swaggerUrl::equals).forEach(subUrl -> subUrl.setUrl(url));
                    }
                });
            }
        }
        this.calculateOauth2RedirectUrl(swaggerUiConfigParameters, uriComponentsBuilder);
    }

    protected abstract String buildUrlWithContextPath(SwaggerUiConfigParameters var1, String var2);

    protected UriComponentsBuilder getUriComponentsBuilder(SwaggerUiConfigParameters swaggerUiConfigParameters, String sbUrl) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl);
        if (this.swaggerUiConfig.getQueryConfigEnabled() != null && this.swaggerUiConfig.getQueryConfigEnabled().booleanValue()) {
            swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"configUrl".equals(entry.getKey())).filter(entry -> !"oauth2RedirectUrl".equals(entry.getKey())).filter(entry -> !"url".equals(entry.getKey())).filter(entry -> !((String)entry.getKey()).startsWith("urls")).filter(entry -> entry.getValue() instanceof String ? StringUtils.isNotEmpty((CharSequence)((String)entry.getValue())) : entry.getValue() != null).forEach(entry -> uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
            uriBuilder.queryParam("configUrl", new Object[]{swaggerUiConfigParameters.getConfigUrl()});
        }
        return uriBuilder;
    }

    protected abstract void calculateOauth2RedirectUrl(SwaggerUiConfigParameters var1, UriComponentsBuilder var2);

    protected abstract void calculateUiRootPath(SwaggerUiConfigParameters var1, StringBuilder ... var2);

    protected void calculateUiRootCommon(SwaggerUiConfigParameters swaggerUiConfigParameters, StringBuilder sbUrl, StringBuilder[] sbUrls) {
        String swaggerPath;
        if (ArrayUtils.isNotEmpty((Object[])sbUrls)) {
            sbUrl = sbUrls[0];
        }
        if ((swaggerPath = swaggerUiConfigParameters.getPath()).contains("/")) {
            sbUrl.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        swaggerUiConfigParameters.setUiRootPath(sbUrl.toString());
    }

    protected abstract void buildApiDocUrl(SwaggerUiConfigParameters var1);

    protected abstract void buildSwaggerConfigUrl(SwaggerUiConfigParameters var1);

    protected String getOauth2RedirectUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl(), (CharSequence)"/swagger-ui/oauth2-redirect.html");
    }

    protected String getSwaggerUiUrl() {
        return "/swagger-ui/index.html";
    }
}

