/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.impl.scripting.ScriptTrace;
import org.flowable.common.engine.impl.scripting.ScriptTraceListener;

public class CompositeScriptTraceListener
implements ScriptTraceListener {
    protected final List<ScriptTraceListener> listeners;

    public CompositeScriptTraceListener(Collection<ScriptTraceListener> listeners) {
        this.listeners = listeners != null ? new ArrayList<ScriptTraceListener>(listeners) : Collections.emptyList();
    }

    @Override
    public void onScriptTrace(ScriptTrace scriptTrace) {
        for (ScriptTraceListener l : this.listeners) {
            l.onScriptTrace(scriptTrace);
        }
    }

    public List<ScriptTraceListener> getListeners() {
        return this.listeners;
    }
}

