/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.audit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.oidc.web.controllers.ciba.OidcCibaResponse;
import org.apereo.cas.util.DigestUtils;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.springframework.http.ResponseEntity;

public class OidcCibaResponseAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    private final AuditEngineProperties properties;

    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        HashMap<String, String> values = new HashMap<String, String>();
        ResponseEntity responseEntity = (ResponseEntity)returnValue;
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            OidcCibaResponse cibaResponse = Objects.requireNonNull((OidcCibaResponse)responseEntity.getBody());
            values.put("auth_req_id", DigestUtils.abbreviate((String)cibaResponse.getAuthenticationRequestId(), (int)this.properties.getAbbreviationLength()));
        } else if (responseEntity.hasBody()) {
            Map body = (Map)responseEntity.getBody();
            values.put("status", responseEntity.getStatusCode().toString());
            values.put("error_description", (String)body.get("error_description"));
        }
        return new String[]{this.auditFormat.serialize(values)};
    }

    @Generated
    public OidcCibaResponseAuditResourceResolver(AuditEngineProperties properties) {
        this.properties = properties;
    }
}

