/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.theme.AbstractThemeResolver;

public class ChainingThemeResolver
extends AbstractThemeResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingThemeResolver.class);
    private final Set<ThemeResolver> chain = new LinkedHashSet<ThemeResolver>();

    @CanIgnoreReturnValue
    public ChainingThemeResolver addResolver(ThemeResolver r) {
        this.chain.add(r);
        return this;
    }

    @Nonnull
    public String resolveThemeName(@Nonnull HttpServletRequest httpServletRequest) {
        for (ThemeResolver themeResolver : this.chain) {
            LOGGER.trace("Attempting to resolve theme via [{}]", (Object)themeResolver.getClass().getSimpleName());
            String resolverTheme = themeResolver.resolveThemeName(httpServletRequest);
            if (resolverTheme.equalsIgnoreCase(this.getDefaultThemeName())) continue;
            LOGGER.trace("Resolved theme [{}]", (Object)resolverTheme);
            return resolverTheme;
        }
        LOGGER.trace("No specific theme could be found. Using default theme [{}]", (Object)this.getDefaultThemeName());
        return this.getDefaultThemeName();
    }

    public void setThemeName(@Nonnull HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String s) {
    }
}

