/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.kafka;

import net.tirasa.connid.bundles.kafka.serialization.SyncDeltaSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class KafkaConfiguration
extends AbstractConfiguration {
    private String bootstrapServers;
    private String clientId;
    private String consumerGroupId;
    private String autoOffsetReset = "earliest";
    private String valueSerializerClassName = SyncDeltaSerializer.class.getName();
    private String valueDeserializerClassName = StringDeserializer.class.getName();
    private String accountTopic = ObjectClass.ACCOUNT_NAME;
    private String groupTopic = ObjectClass.GROUP_NAME;
    private String allTopic = ObjectClass.ALL_NAME;
    private long consumerPollMillis = 100L;

    @ConfigurationProperty(displayMessageKey="bootstrapServers.display", helpMessageKey="bootstrapServers.help", required=true, order=1)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @ConfigurationProperty(displayMessageKey="clientId.display", helpMessageKey="clientId.help", required=true, order=2)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(displayMessageKey="consumerGroupId.display", helpMessageKey="consumerGroupId.help", required=true, order=3)
    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    @ConfigurationProperty(displayMessageKey="autoOffsetReset.display", helpMessageKey="autoOffsetReset.help", required=true, order=4, allowedValues={"earliest", "latest", "none"})
    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    @ConfigurationProperty(displayMessageKey="valueSerializerClassName.display", helpMessageKey="valueSerializerClassName.help", required=true, order=5)
    public String getValueSerializerClassName() {
        return this.valueSerializerClassName;
    }

    public void setValueSerializerClassName(String valueSerializerClassName) {
        this.valueSerializerClassName = valueSerializerClassName;
    }

    @ConfigurationProperty(displayMessageKey="valueDeserializerClassName.display", helpMessageKey="valueDeserializerClassName.help", required=true, order=6)
    public String getValueDeserializerClassName() {
        return this.valueDeserializerClassName;
    }

    public void setValueDeserializerClassName(String valueDeserializerClassName) {
        this.valueDeserializerClassName = valueDeserializerClassName;
    }

    @ConfigurationProperty(displayMessageKey="accountTopic.display", helpMessageKey="accountTopic.help", order=7)
    public String getAccountTopic() {
        return this.accountTopic;
    }

    public void setAccountTopic(String accountTopic) {
        this.accountTopic = accountTopic;
    }

    @ConfigurationProperty(displayMessageKey="groupTopic.display", helpMessageKey="groupTopic.help", order=8)
    public String getGroupTopic() {
        return this.groupTopic;
    }

    public void setGroupTopic(String groupTopic) {
        this.groupTopic = groupTopic;
    }

    @ConfigurationProperty(displayMessageKey="allTopic.display", helpMessageKey="allTopic.help", order=9)
    public String getAllTopic() {
        return this.allTopic;
    }

    public void setAllTopic(String allTopic) {
        this.allTopic = allTopic;
    }

    @ConfigurationProperty(displayMessageKey="consumerPollMillis.display", helpMessageKey="consumerPollMillis.help", order=10)
    public long getConsumerPollMillis() {
        return this.consumerPollMillis;
    }

    public void setConsumerPollMillis(long consumerPollMillis) {
        this.consumerPollMillis = consumerPollMillis;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.bootstrapServers)) {
            throw new ConfigurationException("Missing bootstrap.servers");
        }
        if (StringUtil.isBlank((String)this.clientId)) {
            throw new ConfigurationException("Missing client.id");
        }
        if (StringUtil.isBlank((String)this.consumerGroupId)) {
            throw new ConfigurationException("Missing group.id");
        }
        if (StringUtil.isBlank((String)this.autoOffsetReset)) {
            throw new ConfigurationException("Missing auto.offset.reset");
        }
        if (StringUtil.isBlank((String)this.valueSerializerClassName)) {
            throw new ConfigurationException("Missing value.serializer");
        }
        if (StringUtil.isBlank((String)this.valueDeserializerClassName)) {
            throw new ConfigurationException("Missing value.deserializer");
        }
    }
}

