/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.MultifactorAuthenticationProviderMetadataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorAuthenticationHandler;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorAuthenticationProvider;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationAccountService;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.validation.DefaultCasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.validation.RestfulCasSimpleMultifactorAuthenticationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SimpleMFA})
@Configuration(value="CasSimpleMultifactorAuthenticationEventExecutionPlanConfiguration", proxyBeanMethods=false)
class CasSimpleMultifactorAuthenticationEventExecutionPlanConfiguration {
    CasSimpleMultifactorAuthenticationEventExecutionPlanConfiguration() {
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationService"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasSimpleMultifactorAuthenticationService casSimpleMultifactorAuthenticationService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="casSimpleMultifactorAuthenticationAccountService") ObjectProvider<CasSimpleMultifactorAuthenticationAccountService> accountService, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        return (CasSimpleMultifactorAuthenticationService)BeanSupplier.of(CasSimpleMultifactorAuthenticationService.class).when(BeanCondition.on((String)"cas.authn.mfa.simple.token.rest.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new RestfulCasSimpleMultifactorAuthenticationService(ticketRegistry, simple.getToken().getRest(), ticketFactory)).otherwise(() -> new DefaultCasSimpleMultifactorAuthenticationService(ticketRegistry, ticketFactory, accountService)).get();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationHandler"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationHandler casSimpleMultifactorAuthenticationHandler(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSimpleMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider, @Qualifier(value="casSimpleMultifactorPrincipalFactory") PrincipalFactory casSimpleMultifactorPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="casSimpleMultifactorAuthenticationService") CasSimpleMultifactorAuthenticationService casSimpleMultifactorAuthenticationService, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties props = casProperties.getAuthn().getMfa().getSimple();
        return new CasSimpleMultifactorAuthenticationHandler(props, applicationContext, servicesManager, casSimpleMultifactorPrincipalFactory, casSimpleMultifactorAuthenticationService, multifactorAuthenticationProvider);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationProvider"})
    public MultifactorAuthenticationProvider casSimpleMultifactorAuthenticationProvider(@Qualifier(value="casSimpleMultifactorBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorBypassEvaluator, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        CasSimpleMultifactorAuthenticationProvider p = new CasSimpleMultifactorAuthenticationProvider();
        p.setBypassEvaluator(casSimpleMultifactorBypassEvaluator);
        p.setFailureMode(simple.getFailureMode());
        p.setFailureModeEvaluator(failureModeEvaluator);
        p.setOrder(simple.getRank());
        p.setId(simple.getId());
        return p;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationMetaDataPopulator"})
    public AuthenticationMetaDataPopulator casSimpleMultifactorAuthenticationMetaDataPopulator(@Qualifier(value="casSimpleMultifactorAuthenticationProvider") MultifactorAuthenticationProvider casSimpleMultifactorAuthenticationProvider, @Qualifier(value="casSimpleMultifactorAuthenticationHandler") AuthenticationHandler casSimpleMultifactorAuthenticationHandler, CasConfigurationProperties casProperties) {
        return new AuthenticationContextAttributeMetaDataPopulator(casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), casSimpleMultifactorAuthenticationHandler, casSimpleMultifactorAuthenticationProvider.getId());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorProviderAuthenticationMetadataPopulator"})
    public AuthenticationMetaDataPopulator casSimpleMultifactorProviderAuthenticationMetadataPopulator(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="casSimpleMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
        return new MultifactorAuthenticationProviderMetadataPopulator(authenticationContextAttribute, multifactorAuthenticationProvider, servicesManager);
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory casSimpleMultifactorPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer casSimpleMultifactorAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="casSimpleMultifactorProviderAuthenticationMetadataPopulator") AuthenticationMetaDataPopulator casSimpleMultifactorProviderAuthenticationMetadataPopulator, @Qualifier(value="casSimpleMultifactorAuthenticationHandler") AuthenticationHandler casSimpleMultifactorAuthenticationHandler, @Qualifier(value="casSimpleMultifactorAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator casSimpleMultifactorAuthenticationMetaDataPopulator, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver principalResolver) {
        return plan -> {
            plan.registerAuthenticationHandler(casSimpleMultifactorAuthenticationHandler);
            plan.registerAuthenticationMetadataPopulator(casSimpleMultifactorAuthenticationMetaDataPopulator);
            plan.registerAuthenticationMetadataPopulator(casSimpleMultifactorProviderAuthenticationMetadataPopulator);
            plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{CasSimpleMultifactorTokenCredential.class}));
        };
    }
}

