/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.web;

import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.app.WicketBootWebApplication;
import com.giffing.wicket.spring.boot.starter.web.WicketWebInitializerProperties;
import com.giffing.wicket.spring.boot.starter.web.config.WicketWebInitializerAutoConfig;
import com.giffing.wicket.spring.boot.starter.web.config.WicketWebInitializerConfig;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={WicketWebInitializerAutoConfig.class})
@EnableConfigurationProperties(value={WicketWebInitializerProperties.class})
public class WicketWebInitializer {
    public static final String WICKET_FILTERNAME = "wicket-filter";

    @Bean
    public FilterRegistrationBean<WicketFilter> wicketFilter(WicketWebInitializerConfig wicketWebInitializerConfig, WicketWebInitializerProperties props, WicketEndpointRepository wicketEndpointRepository, WicketBootWebApplication wicketBootWebApplication) {
        WicketFilter wicketFilter = wicketWebInitializerConfig.createWicketFilter((WebApplication)wicketBootWebApplication);
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)wicketFilter, new ServletRegistrationBean[0]);
        filter.setName(WICKET_FILTERNAME);
        filter.addUrlPatterns(new String[]{props.getFilterMappingParam()});
        filter.setDispatcherTypes(EnumSet.copyOf(props.getDispatcherTypes()));
        filter.setMatchAfter(props.isFilterMatchAfter());
        filter.addInitParameter("filterMappingUrlPattern", props.getFilterMappingParam());
        props.getInitParameters().forEach((arg_0, arg_1) -> ((FilterRegistrationBean)filter).addInitParameter(arg_0, arg_1));
        wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("wicketFilterName", (Object)WICKET_FILTERNAME).withDetail("wicketFilterClass", wicketFilter.getClass()).withDetail("properties", (Object)props).build());
        return filter;
    }
}

