/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.menu;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryPanel;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.KendoIcon;
import com.googlecode.wicket.kendo.ui.widget.menu.IMenuListener;
import com.googlecode.wicket.kendo.ui.widget.menu.MenuBehavior;
import com.googlecode.wicket.kendo.ui.widget.menu.item.IMenuItem;
import com.googlecode.wicket.kendo.ui.widget.menu.item.UrlMenuItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public class Menu
extends JQueryPanel
implements IMenuListener {
    private static final long serialVersionUID = 1L;
    private final List<IMenuItem> items;
    private WebMarkupContainer root;
    private Map<String, IMenuItem> map = Generics.newHashMap();

    public Menu(String id) {
        this(id, new ArrayList<IMenuItem>());
    }

    public Menu(String id, List<IMenuItem> items) {
        super(id);
        this.items = (List)Args.notNull(items, (String)"items");
        this.initialize();
    }

    public Menu(String id, Options options) {
        this(id, new ArrayList<IMenuItem>(), options);
    }

    public Menu(String id, List<IMenuItem> items, Options options) {
        super(id, options);
        this.items = (List)Args.notNull(items, (String)"items");
        this.initialize();
    }

    private void initialize() {
        this.root = new WebMarkupContainer("root");
        this.root.add(new Component[]{new ListFragment("list", this.items)});
        this.add(new Component[]{this.root});
    }

    public void reload(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this});
    }

    public List<IMenuItem> getItemList() {
        return this.items;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)this.root)});
    }

    @Override
    public void onClick(AjaxRequestTarget target, IMenuItem item) {
    }

    public MenuBehavior newWidgetBehavior(String selector) {
        return new MenuBehavior(selector, this.options, (IMenuListener)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, IMenuItem> getMenuItemMap() {
                return Menu.this.getMenuItemsMap();
            }
        };
    }

    protected Map<String, IMenuItem> getMenuItemsMap() {
        return this.map;
    }

    protected void addMenuItem(ListItem<IMenuItem> item, IMenuItem menuItem) {
        if (menuItem instanceof UrlMenuItem) {
            item.add(new Component[]{new LinkFragment("item", (UrlMenuItem)menuItem)});
            item.add(new Component[]{new EmptyPanel("menu")});
        } else {
            item.add(new Component[]{new ItemFragment("item", menuItem)});
            if (this.hasSubMenus(menuItem)) {
                item.add(new Component[]{new MenuFragment("menu", menuItem.getItems())});
            } else {
                item.add(new Component[]{new EmptyPanel("menu")});
            }
        }
    }

    protected boolean hasSubMenus(IMenuItem item) {
        return item.isEnabled() && !item.getItems().isEmpty();
    }

    private class ListFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ListFragment(String id, List<IMenuItem> items) {
            super(id, "list-fragment", (MarkupContainer)Menu.this);
            this.add(new Component[]{new ListView<IMenuItem>("items", items){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<IMenuItem> item) {
                    IMenuItem menuItem = (IMenuItem)item.getModelObject();
                    String menuItemId = menuItem.getId();
                    Menu.this.map.put(menuItemId, menuItem);
                    item.add(new Behavior[]{AttributeModifier.replace((String)"id", (Serializable)((Object)menuItemId))});
                    Menu.this.addMenuItem(item, menuItem);
                    if (!menuItem.isEnabled()) {
                        item.add(new Behavior[]{AttributeModifier.append((String)"disabled", (IModel)Model.of((Serializable)((Object)"disabled")))});
                    }
                    if (menuItem.isSelected()) {
                        item.add(new Behavior[]{AttributeModifier.append((String)"class", (IModel)Model.of((Serializable)((Object)"menu-item-selected")))});
                    }
                }
            }});
        }
    }

    private class LinkFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public LinkFragment(String id, UrlMenuItem item) {
            super(id, "link-fragment", (MarkupContainer)Menu.this);
            WebMarkupContainer link = new WebMarkupContainer("link");
            link.add(new Behavior[]{AttributeModifier.replace((String)"href", (Serializable)((Object)item.getUrl()))});
            link.add(new Component[]{new EmptyPanel("icon").add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)KendoIcon.getCssClass(item.getIcon())))})});
            link.add(new Component[]{new Label("title", item.getTitle()).setRenderBodyOnly(true)});
            this.add(new Component[]{link});
        }
    }

    private class ItemFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ItemFragment(String id, IMenuItem item) {
            super(id, "item-fragment", (MarkupContainer)Menu.this);
            this.add(new Component[]{new EmptyPanel("icon").add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)KendoIcon.getCssClass(item.getIcon())))})});
            this.add(new Component[]{new Label("title", item.getTitle()).setRenderBodyOnly(true)});
        }
    }

    private class MenuFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public MenuFragment(String id, List<IMenuItem> items) {
            super(id, "menu-fragment", (MarkupContainer)Menu.this);
            this.add(new Component[]{new ListFragment("list", items)});
            this.setVisible(!items.isEmpty());
        }
    }
}

