/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.store.FolderException;
import jakarta.mail.Quota;

public class QuotaCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "QUOTA";

    QuotaCommand() {
        super(NAME, null);
    }

    public QuotaCommand(String name) {
        super(name, null);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException, AuthorizationException {
        Quota[] quota;
        if (!session.getHost().getStore().isQuotaSupported()) {
            response.commandFailed(this, "Quota is not supported. Activate quota capability first");
        }
        String root = this.parser.mailbox(request);
        for (Quota q : quota = session.getHost().getStore().getQuota(root, session.getUser().getQualifiedMailboxName())) {
            StringBuilder buf = new StringBuilder();
            this.appendQuota(q, buf);
            response.untaggedResponse(buf.toString());
        }
        response.commandComplete(this);
    }

    protected void appendQuota(Quota quota, StringBuilder buf) {
        buf.append("QUOTA ");
        this.appendQuotaRootName(quota, buf);
        buf.append(" ");
        buf.append('(');
        boolean pad = false;
        for (Quota.Resource resource : quota.resources) {
            if (pad) {
                buf.append(" ");
            }
            buf.append(resource.name);
            buf.append(" ").append(resource.usage);
            buf.append(" ").append(resource.limit);
            pad = true;
        }
        buf.append(')');
    }

    protected void appendQuotaRootName(Quota quota, StringBuilder buf) {
        String rootName = quota.quotaRoot;
        if (null == rootName || rootName.isEmpty()) {
            rootName = "\"\"";
        }
        buf.append('\"').append(rootName).append('\"');
    }
}

