/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.core.logic.AbstractJobLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.provisioning.api.data.NotificationDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class NotificationLogic
extends AbstractJobLogic<NotificationTO> {
    protected final NotificationDAO notificationDAO;
    protected final NotificationDataBinder binder;

    public NotificationLogic(JobManager jobManager, SyncopeTaskScheduler scheduler, JobStatusDAO jobStatusDAO, NotificationDAO notificationDAO, NotificationDataBinder binder) {
        super(jobManager, scheduler, jobStatusDAO);
        this.notificationDAO = notificationDAO;
        this.binder = binder;
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_READ')")
    @Transactional(readOnly=true)
    public NotificationTO read(String key) {
        Notification notification = (Notification)this.notificationDAO.findById(key).orElseThrow(() -> new NotFoundException("Notification " + key));
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_LIST')")
    @Transactional(readOnly=true)
    public List<NotificationTO> list() {
        return this.notificationDAO.findAll().stream().map(arg_0 -> ((NotificationDataBinder)this.binder).getNotificationTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_CREATE')")
    public NotificationTO create(NotificationTO notificationTO) {
        return this.binder.getNotificationTO((Notification)this.notificationDAO.save((Entity)this.binder.create(notificationTO)));
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_UPDATE')")
    public NotificationTO update(NotificationTO notificationTO) {
        Notification notification = (Notification)this.notificationDAO.findById(notificationTO.getKey()).orElseThrow(() -> new NotFoundException("Notification " + notificationTO.getKey()));
        this.binder.update(notification, notificationTO);
        notification = (Notification)this.notificationDAO.save((Entity)notification);
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_DELETE')")
    public NotificationTO delete(String key) {
        Notification notification = (Notification)this.notificationDAO.findById(key).orElseThrow(() -> new NotFoundException("Notification " + key));
        NotificationTO deleted = this.binder.getNotificationTO(notification);
        this.notificationDAO.deleteById(key);
        return deleted;
    }

    @Override
    protected Triple<JobType, String, String> getReference(String jobName) {
        return "notificationJob".equals(jobName) ? Triple.of((Object)JobType.NOTIFICATION, null, (Object)NotificationJob.class.getSimpleName()) : null;
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_LIST')")
    public JobTO getJob() {
        List<JobTO> jobs = super.doListJobs(false);
        return jobs.isEmpty() ? null : jobs.getFirst();
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_EXECUTE')")
    public void actionJob(JobAction action) {
        super.doActionJob("notificationJob", action);
    }

    @Override
    protected NotificationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof NotificationTO)) continue;
                NotificationTO notificationTO = (NotificationTO)object;
                key = notificationTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getNotificationTO((Notification)this.notificationDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

