/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtils;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class PolicyLogic
extends AbstractTransactionalLogic<PolicyTO> {
    protected final PolicyDAO policyDAO;
    protected final PolicyDataBinder binder;
    protected final PolicyUtilsFactory policyUtilsFactory;

    public PolicyLogic(PolicyDAO policyDAO, PolicyDataBinder binder, PolicyUtilsFactory policyUtilsFactory) {
        this.policyDAO = policyDAO;
        this.binder = binder;
        this.policyUtilsFactory = policyUtilsFactory;
    }

    @PreAuthorize(value="hasRole('POLICY_CREATE')")
    public <T extends PolicyTO> T create(PolicyType type, T policyTO) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(policyTO);
        if (policyUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(policyUtils.getType()) + ", expected " + String.valueOf(type));
            throw sce;
        }
        return (T)this.binder.getPolicyTO((Policy)this.policyDAO.save((Entity)this.binder.create(policyTO)));
    }

    @PreAuthorize(value="hasRole('POLICY_UPDATE')")
    public PolicyTO update(PolicyType type, PolicyTO policyTO) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(type);
        Policy policy = (Policy)this.policyDAO.findById(policyTO.getKey(), policyUtils.policyClass()).orElseThrow(() -> new NotFoundException(String.valueOf(type) + " Policy " + policyTO.getKey()));
        if (this.policyUtilsFactory.getInstance(policyTO).getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + policyTO.getClass().getName() + ", expected " + String.valueOf(type));
            throw sce;
        }
        return this.binder.getPolicyTO((Policy)this.policyDAO.save((Entity)this.binder.update(policy, policyTO)));
    }

    @PreAuthorize(value="hasRole('POLICY_LIST')")
    @Transactional(readOnly=true)
    public <T extends PolicyTO> List<T> list(PolicyType type) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(type);
        return this.policyDAO.findAll(policyUtils.policyClass()).stream().map(arg_0 -> ((PolicyDataBinder)this.binder).getPolicyTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('POLICY_READ')")
    @Transactional(readOnly=true)
    public <T extends PolicyTO> T read(PolicyType type, String key) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(type);
        Policy policy = (Policy)this.policyDAO.findById(key, policyUtils.policyClass()).orElseThrow(() -> new NotFoundException(String.valueOf(type) + " Policy " + key));
        return (T)this.binder.getPolicyTO(policy);
    }

    @PreAuthorize(value="hasRole('POLICY_DELETE')")
    public <T extends PolicyTO> T delete(PolicyType type, String key) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(type);
        Policy policy = (Policy)this.policyDAO.findById(key, policyUtils.policyClass()).orElseThrow(() -> new NotFoundException(String.valueOf(type) + " Policy " + key));
        PolicyTO deleted = this.binder.getPolicyTO(policy);
        this.policyDAO.delete((Entity)policy);
        return (T)deleted;
    }

    @Override
    protected PolicyTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        if (ArrayUtils.isEmpty((Object[])args) || args.length != 2) {
            throw new UnresolvedReferenceException();
        }
        try {
            String key;
            PolicyType policyType;
            Object object = args[0];
            if (!(object instanceof PolicyType)) {
                throw new RuntimeException("Invalid Policy type");
            }
            PolicyType type = policyType = (PolicyType)object;
            Object object2 = args[1];
            if (object2 instanceof String) {
                String string;
                key = string = (String)object2;
            } else {
                object2 = args[1];
                if (object2 instanceof PolicyTO) {
                    PolicyTO policyTO = (PolicyTO)object2;
                    key = policyTO.getKey();
                } else {
                    throw new RuntimeException("Invalid ClientApp key");
                }
            }
            return this.read(type, key);
        }
        catch (Throwable t) {
            throw new UnresolvedReferenceException();
        }
    }
}

