/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.fedplanner.FederatedCompilationTimer;
import org.apache.sysds.hops.fedplanner.FederatedPlannerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandlerException;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.fed.InitFEDInstruction;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;
import org.apache.sysds.utils.JSONHelper;
import org.apache.wink.json4j.JSONObject;

public class PrivacyConstraintLoader {
    private final Map<Long, Hop> memo = new HashMap<Long, Hop>();
    private final Map<String, Hop> transientWrites = new HashMap<String, Hop>();
    private LocalVariableMap localVariableMap = new LocalVariableMap();

    public void loadConstraints(DMLProgram prog) {
        FederatedCompilationTimer.startPrivProcessTimer();
        this.rewriteStatementBlocks(prog, prog.getStatementBlocks(), null);
        FederatedCompilationTimer.stopPrivProcessTimer();
    }

    private void rewriteStatementBlocks(DMLProgram prog, List<StatementBlock> sbs, Map<String, Hop> paramMap) {
        sbs.forEach(block -> this.rewriteStatementBlock(prog, (StatementBlock)block, paramMap));
    }

    private void rewriteStatementBlock(DMLProgram prog, StatementBlock block, Map<String, Hop> paramMap) {
        if (block instanceof WhileStatementBlock) {
            this.rewriteWhileStatementBlock(prog, (WhileStatementBlock)block, paramMap);
        } else if (block instanceof IfStatementBlock) {
            this.rewriteIfStatementBlock(prog, (IfStatementBlock)block, paramMap);
        } else if (block instanceof ForStatementBlock) {
            this.rewriteForStatementBlock(prog, (ForStatementBlock)block, paramMap);
        } else if (block instanceof FunctionStatementBlock) {
            this.rewriteFunctionStatementBlock(prog, (FunctionStatementBlock)block, paramMap);
        } else {
            this.rewriteDefaultStatementBlock(prog, block, paramMap);
        }
    }

    private void rewriteWhileStatementBlock(DMLProgram prog, WhileStatementBlock whileSB, Map<String, Hop> paramMap) {
        Hop whilePredicateHop = whileSB.getPredicateHops();
        this.loadPrivacyConstraint(whilePredicateHop, paramMap);
        for (Statement stm : whileSB.getStatements()) {
            WhileStatement whileStm = (WhileStatement)stm;
            this.rewriteStatementBlocks(prog, whileStm.getBody(), paramMap);
        }
    }

    private void rewriteIfStatementBlock(DMLProgram prog, IfStatementBlock ifSB, Map<String, Hop> paramMap) {
        this.loadPrivacyConstraint(ifSB.getPredicateHops(), paramMap);
        for (Statement statement : ifSB.getStatements()) {
            IfStatement ifStatement = (IfStatement)statement;
            this.rewriteStatementBlocks(prog, ifStatement.getIfBody(), paramMap);
            this.rewriteStatementBlocks(prog, ifStatement.getElseBody(), paramMap);
        }
    }

    private void rewriteForStatementBlock(DMLProgram prog, ForStatementBlock forSB, Map<String, Hop> paramMap) {
        this.loadPrivacyConstraint(forSB.getFromHops(), paramMap);
        this.loadPrivacyConstraint(forSB.getToHops(), paramMap);
        this.loadPrivacyConstraint(forSB.getIncrementHops(), paramMap);
        DataIdentifier iterVar = ((ForStatement)forSB.getStatement(0)).getIterablePredicate().getIterVar();
        LocalVariableMap tmpLocalVariableMap = this.localVariableMap;
        this.localVariableMap = (LocalVariableMap)this.localVariableMap.clone();
        this.localVariableMap.put(iterVar.getName(), new IntObject(-1L));
        for (Statement statement : forSB.getStatements()) {
            ForStatement forStatement = (ForStatement)statement;
            this.rewriteStatementBlocks(prog, forStatement.getBody(), paramMap);
        }
        this.localVariableMap = tmpLocalVariableMap;
    }

    private void rewriteFunctionStatementBlock(DMLProgram prog, FunctionStatementBlock funcSB, Map<String, Hop> paramMap) {
        for (Statement statement : funcSB.getStatements()) {
            FunctionStatement funcStm = (FunctionStatement)statement;
            this.rewriteStatementBlocks(prog, funcStm.getBody(), paramMap);
        }
    }

    private void rewriteDefaultStatementBlock(DMLProgram prog, StatementBlock sb, Map<String, Hop> paramMap) {
        if (sb.hasHops()) {
            for (Hop sbHop : sb.getHops()) {
                this.loadPrivacyConstraint(sbHop, paramMap);
                if (!(sbHop instanceof FunctionOp)) continue;
                String funcName = ((FunctionOp)sbHop).getFunctionName();
                Map<String, Hop> funcParamMap = FederatedPlannerUtils.getParamMap((FunctionOp)sbHop);
                if (paramMap != null && funcParamMap != null) {
                    funcParamMap.putAll(paramMap);
                }
                paramMap = funcParamMap;
                FunctionStatementBlock sbFuncBlock = prog.getBuiltinFunctionDictionary().getFunction(funcName);
                this.rewriteStatementBlock(prog, sbFuncBlock, paramMap);
                FunctionStatement funcStatement = (FunctionStatement)sbFuncBlock.getStatement(0);
                FederatedPlannerUtils.mapFunctionOutputs((FunctionOp)sbHop, funcStatement, this.transientWrites);
            }
        }
    }

    private void loadPrivacyConstraint(Hop root, Map<String, Hop> paramMap) {
        if (root != null && !this.memo.containsKey(root.getHopID())) {
            for (Hop input : root.getInput()) {
                this.loadPrivacyConstraint(input, paramMap);
            }
            this.propagatePrivConstraintsLocal(root, paramMap);
            this.memo.put(root.getHopID(), root);
        }
    }

    private void propagatePrivConstraintsLocal(Hop currentHop, Map<String, Hop> paramMap) {
        if (currentHop.isFederatedDataOp()) {
            this.loadFederatedPrivacyConstraints(currentHop);
        } else if (HopRewriteUtils.isData(currentHop, Types.OpOpData.TRANSIENTWRITE)) {
            currentHop.setPrivacy(currentHop.getInput(0).getPrivacy());
            this.transientWrites.put(currentHop.getName(), currentHop);
        } else if (HopRewriteUtils.isData(currentHop, Types.OpOpData.TRANSIENTREAD)) {
            ArrayList<Hop> tInputs = FederatedPlannerUtils.getTransientInputs(currentHop, paramMap, this.transientWrites, this.localVariableMap);
            if (tInputs != null && tInputs.get(0) != null) {
                currentHop.setPrivacy(tInputs.get(0).getPrivacy());
            }
        } else {
            PrivacyPropagator.hopPropagation(currentHop);
        }
    }

    public void loadFederatedPrivacyConstraints(Hop hop) {
        FederatedCompilationTimer.TimeEntry fetchTime = FederatedCompilationTimer.startPrivFetchTimer(hop.getHopID());
        try {
            PrivacyConstraint.PrivacyLevel constraintLevel = ((Stream)hop.getInput(0).getInput().stream().parallel()).map(in -> ((LiteralOp)in).getStringValue()).map(PrivacyConstraintLoader::sendPrivConstraintRequest).map(PrivacyConstraintLoader::unwrapPrivConstraint).map(constraint -> constraint != null ? constraint.getPrivacyLevel() : PrivacyConstraint.PrivacyLevel.None).reduce(PrivacyConstraint.PrivacyLevel.None, (out, in) -> {
                if (out == PrivacyConstraint.PrivacyLevel.Private || in == PrivacyConstraint.PrivacyLevel.Private) {
                    return PrivacyConstraint.PrivacyLevel.Private;
                }
                if (out == PrivacyConstraint.PrivacyLevel.PrivateAggregation || in == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                    return PrivacyConstraint.PrivacyLevel.PrivateAggregation;
                }
                return out;
            });
            PrivacyConstraint fedDataPrivConstraint = constraintLevel != PrivacyConstraint.PrivacyLevel.None ? new PrivacyConstraint(constraintLevel) : null;
            hop.setPrivacy(fedDataPrivConstraint);
        }
        catch (Exception ex) {
            throw new DMLException(ex);
        }
        finally {
            fetchTime.stopTime();
        }
    }

    private static Future<FederatedResponse> sendPrivConstraintRequest(String address) {
        try {
            String[] parsedAddress = InitFEDInstruction.parseURL(address);
            String host = parsedAddress[0];
            int port = Integer.parseInt(parsedAddress[1]);
            PrivacyConstraintRetriever retriever = new PrivacyConstraintRetriever(parsedAddress[2]);
            FederatedRequest privacyRetrieval = new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, retriever);
            InetSocketAddress inetAddress = new InetSocketAddress(InetAddress.getByName(host), port);
            return FederatedData.executeFederatedOperation(inetAddress, privacyRetrieval);
        }
        catch (UnknownHostException ex) {
            throw new DMLException(ex);
        }
    }

    private static PrivacyConstraint unwrapPrivConstraint(Future<FederatedResponse> privConstraintFuture) {
        try {
            FederatedResponse privConstraintResponse = privConstraintFuture.get();
            return (PrivacyConstraint)privConstraintResponse.getData()[0];
        }
        catch (Exception ex) {
            throw new DMLException(ex);
        }
    }

    public static class PrivacyConstraintRetriever
    extends FederatedUDF {
        private static final long serialVersionUID = 3551741240135587183L;
        private final String filename;

        public PrivacyConstraintRetriever(String filename) {
            super(new long[0]);
            this.filename = filename;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            PrivacyConstraint privacyConstraint;
            FileSystem fs = null;
            try {
                String mtdname = DataExpression.getMTDFileName(this.filename);
                Path path = new Path(mtdname);
                fs = IOUtilFunctions.getFileSystem(mtdname);
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                    JSONObject metadataObject = JSONHelper.parse(br);
                    privacyConstraint = PrivacyPropagator.parseAndReturnPrivacyConstraint(metadataObject);
                }
            }
            catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        String msg = "Exception in reading metadata of: " + this.filename;
                        throw new DMLRuntimeException(msg);
                    }
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(fs);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently((Closeable)fs);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, privacyConstraint);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

