/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.lib.CLALibUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CLALibAppend {
    private static final Log LOG = LogFactory.getLog((String)CLALibAppend.class.getName());

    public static MatrixBlock append(MatrixBlock left, MatrixBlock right, int k) {
        int m = left.getNumRows();
        int n = left.getNumColumns() + right.getNumColumns();
        if (left.isEmpty() && right instanceof CompressedMatrixBlock) {
            return CLALibAppend.appendLeftEmpty(left, (CompressedMatrixBlock)right, m, n);
        }
        if (right.isEmpty() && left instanceof CompressedMatrixBlock) {
            return CLALibAppend.appendRightEmpty((CompressedMatrixBlock)left, right, m, n);
        }
        if (!(left instanceof CompressedMatrixBlock) && left.getInMemorySize() < 1000L) {
            LOG.info((Object)"Trying to compress left side of append");
            left = (MatrixBlock)CompressedMatrixBlockFactory.compress(left, k).getLeft();
        }
        if (!(right instanceof CompressedMatrixBlock) && left.getInMemorySize() < 1000L) {
            LOG.info((Object)"Trying to compress right side of append");
            right = (MatrixBlock)CompressedMatrixBlockFactory.compress(right, k).getLeft();
        }
        if (!(left instanceof CompressedMatrixBlock) || !(right instanceof CompressedMatrixBlock)) {
            double estSizeCompressed;
            double spar = (double)(left.getNonZeros() + right.getNonZeros()) / ((double)m * (double)n);
            double estSizeUncompressed = MatrixBlock.estimateSizeInMemory(m, n, spar);
            if (estSizeUncompressed < (estSizeCompressed = (double)(left.getInMemorySize() + right.getInMemorySize()))) {
                return CLALibAppend.uc(left).append(CLALibAppend.uc(right), null);
            }
            if (left instanceof CompressedMatrixBlock) {
                return CLALibAppend.appendRightUncompressed((CompressedMatrixBlock)left, right, m, n);
            }
            return CLALibAppend.appendLeftUncompressed(left, (CompressedMatrixBlock)right, m, n);
        }
        return CLALibAppend.append((CompressedMatrixBlock)left, (CompressedMatrixBlock)right, m, n);
    }

    private static MatrixBlock appendLeftUncompressed(MatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        List<AColGroup> prev = right.getColGroups();
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(prev.size() + 1);
        int nColL = left.getNumColumns();
        IColIndex colIdx = ColIndexFactory.create(nColL);
        AColGroup g = ColGroupUncompressed.create(colIdx, left, false);
        newGroup.add(g);
        for (AColGroup group : prev) {
            newGroup.add(group.shiftColIndices(nColL));
        }
        ret.allocateColGroupList(newGroup);
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        return ret;
    }

    private static MatrixBlock appendRightUncompressed(CompressedMatrixBlock left, MatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        List<AColGroup> prev = left.getColGroups();
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(prev.size() + 1);
        newGroup.addAll(prev);
        int cLenL = left.getNumColumns();
        int cLenR = right.getNumColumns();
        IColIndex colIdx = ColIndexFactory.create(cLenL, cLenR + cLenL);
        AColGroup g = ColGroupUncompressed.create(colIdx, right, false);
        newGroup.add(g);
        ret.allocateColGroupList(newGroup);
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        return ret;
    }

    private static MatrixBlock append(CompressedMatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        CLALibAppend.appendColGroups(ret, left.getColGroups(), right.getColGroups(), left.getNumColumns());
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        ret.setOverlapping(left.isOverlapping() || right.isOverlapping());
        double compressedSize = ret.getInMemorySize();
        double uncompressedSize = MatrixBlock.estimateSizeInMemory(m, n, ret.getSparsity());
        if (compressedSize < uncompressedSize) {
            return ret;
        }
        double ratio = uncompressedSize / compressedSize;
        String message = String.format("Decompressing c bind matrix because it had to small compression ratio: %2.3f", ratio);
        return ret.getUncompressed(message);
    }

    private static MatrixBlock appendRightEmpty(CompressedMatrixBlock left, MatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.create(right.getNumColumns()));
        CLALibAppend.appendColGroups(ret, left.getColGroups(), newGroup, left.getNumColumns());
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        ret.setOverlapping(left.isOverlapping());
        return ret;
    }

    private static MatrixBlock appendLeftEmpty(MatrixBlock left, CompressedMatrixBlock right, int m, int n) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.create(left.getNumColumns()));
        CLALibAppend.appendColGroups(ret, newGroup, right.getColGroups(), left.getNumColumns());
        ret.setNonZeros(left.getNonZeros() + right.getNonZeros());
        ret.setOverlapping(right.isOverlapping());
        return ret;
    }

    private static void appendColGroups(CompressedMatrixBlock ret, List<AColGroup> left, List<AColGroup> right, int leftNumCols) {
        ret.allocateColGroupList(new ArrayList<AColGroup>(left.size() + right.size()));
        for (AColGroup group : left) {
            ret.getColGroups().add(group);
        }
        for (AColGroup group : right) {
            ret.getColGroups().add(group.shiftColIndices(leftNumCols));
        }
        CLALibUtils.combineConstColumns(ret);
    }

    private static MatrixBlock uc(MatrixBlock mb) {
        return CompressedMatrixBlock.getUncompressed(mb, "append");
    }
}

