/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.List;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.EvalNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderBin;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderFeatureHash;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.utils.stats.TransformStatistics;

public class ColumnEncoderUDF
extends ColumnEncoder {
    private final String _fName;
    public int _domainSize = 1;

    protected ColumnEncoderUDF(int ptCols, String name) {
        super(ptCols);
        this._fName = name;
    }

    public ColumnEncoderUDF() {
        this(-1, null);
    }

    @Override
    protected ColumnEncoder.TransformType getTransformType() {
        return ColumnEncoder.TransformType.UDF;
    }

    @Override
    public void build(CacheBlock<?> in) {
    }

    @Override
    public List<DependencyTask<?>> getBuildTasks(CacheBlock<?> in) {
        return null;
    }

    @Override
    public void applyDense(CacheBlock<?> in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ExecutionContext ec = ExecutionContextFactory.createContext(new Program(new DMLProgram()));
        MatrixBlock col = out.slice(0, in.getNumRows() - 1, outputCol, outputCol + this._domainSize - 1, new MatrixBlock());
        ec.setVariable("I", new ListObject(new Data[]{ParamservUtils.newMatrixObject(col, true)}));
        ec.setVariable("O", ParamservUtils.newMatrixObject(col, true));
        EvalNaryCPInstruction fun = new EvalNaryCPInstruction(null, "eval", "", new CPOperand("O", Types.ValueType.FP64, Types.DataType.MATRIX), new CPOperand(this._fName, Types.ValueType.STRING, Types.DataType.SCALAR, true), new CPOperand("I", Types.ValueType.UNKNOWN, Types.DataType.LIST));
        fun.processInstruction(ec);
        MatrixBlock ret = (MatrixBlock)((MatrixObject)ec.getCacheableData("O")).acquireReadAndRelease();
        out.copy(0, in.getNumRows() - 1, outputCol, outputCol + this._domainSize - 1, ret, true);
        if (DMLScript.STATISTICS) {
            TransformStatistics.incUDFApplyTime(System.nanoTime() - t0);
        }
    }

    public void updateDomainSizes(List<ColumnEncoder> columnEncoders) {
        if (this._colID == -1) {
            return;
        }
        for (ColumnEncoder columnEncoder : columnEncoders) {
            int distinct = -1;
            if (columnEncoder instanceof ColumnEncoderRecode) {
                ColumnEncoderRecode columnEncoderRecode = (ColumnEncoderRecode)columnEncoder;
                distinct = columnEncoderRecode.getNumDistinctValues();
            } else if (columnEncoder instanceof ColumnEncoderBin) {
                distinct = ((ColumnEncoderBin)columnEncoder)._numBin;
            } else if (columnEncoder instanceof ColumnEncoderFeatureHash) {
                distinct = (int)((ColumnEncoderFeatureHash)columnEncoder).getK();
            }
            if (distinct == -1) continue;
            this._domainSize = distinct;
            LOG.debug((Object)("DummyCoder for column: " + this._colID + " has domain size: " + this._domainSize));
        }
    }

    protected ColumnEncoder.ColumnApplyTask<ColumnEncoderUDF> getSparseTask(CacheBlock<?> in, MatrixBlock out, int outputCol, int startRow, int blk) {
        throw new DMLRuntimeException("UDF encoders do not support sparse tasks.");
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderUDF) {
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public void allocateMetaData(FrameBlock meta) {
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }

    @Override
    protected double getCode(CacheBlock<?> in, int row) {
        throw new DMLRuntimeException("UDF encoders only support full column access.");
    }

    @Override
    protected double[] getCodeCol(CacheBlock<?> in, int startInd, int blkSize) {
        throw new DMLRuntimeException("UDF encoders only support full column access.");
    }
}

