/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.ASDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupIO;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDC
extends ASDC
implements AMapToDataGroup {
    private static final long serialVersionUID = 769993538831949086L;
    protected final AMapToData _data;
    protected final double[] _defaultTuple;

    protected ColGroupSDC(IColIndex colIndices, int numRows, ADictionary dict, double[] defaultTuple, AOffset offsets, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, offsets, cachedCounts);
        if (data.getUnique() != dict.getNumberOfValues(colIndices.size())) {
            if (data.getUnique() != data.getMax()) {
                throw new DMLCompressionException("Invalid unique count compared to actual: " + data.getUnique() + " " + data.getMax());
            }
            throw new DMLCompressionException("Invalid construction of SDC group: number uniques: " + data.getUnique() + " vs." + dict.getNumberOfValues(colIndices.size()));
        }
        if (defaultTuple.length != colIndices.size()) {
            throw new DMLCompressionException("Invalid construction of SDC group");
        }
        this._data = data;
        this._defaultTuple = defaultTuple;
    }

    public static AColGroup create(IColIndex colIndices, int numRows, ADictionary dict, double[] defaultTuple, AOffset offsets, AMapToData data, int[] cachedCounts) {
        boolean allZero = ColGroupUtils.allZero(defaultTuple);
        if (dict == null && allZero) {
            return new ColGroupEmpty(colIndices);
        }
        if (dict == null || dict.getNumberOfValues(colIndices.size()) == 1) {
            return ColGroupSDCSingle.create(colIndices, numRows, dict, defaultTuple, offsets, null);
        }
        if (allZero) {
            return ColGroupSDCZeros.create(colIndices, numRows, dict, offsets, data, cachedCounts);
        }
        if (data.getUnique() == 1) {
            MatrixBlock mb = dict.getMBDict(colIndices.size()).getMatrixBlock().slice(0, 0);
            return ColGroupSDCSingle.create(colIndices, numRows, MatrixBlockDictionary.create(mb), defaultTuple, offsets, null);
        }
        return new ColGroupSDC(colIndices, numRows, dict, defaultTuple, offsets, data, cachedCounts);
    }

    public AColGroup sparsifyFOR() {
        return ColGroupSDCFOR.sparsifyFOR(this);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDC;
    }

    @Override
    public double[] getDefaultTuple() {
        return this._defaultTuple;
    }

    @Override
    public AMapToData getMapToData() {
        return this._data;
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return this._defaultTuple[colIdx];
        }
        return this._dict.getValue(this._data.getIndex(it.getDataIndex()), colIdx, this._colIndexes.size());
    }

    @Override
    protected double[] preAggSumRows() {
        return this._dict.sumAllRowsToDoubleWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggSumSqRows() {
        return this._dict.sumAllRowsToDoubleSqWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggProductRows() {
        return this._dict.productAllRowsToDoubleWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggBuiltinRows(Builtin builtin) {
        return this._dict.aggregateRowsWithDefault(builtin, this._defaultTuple);
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        double ret = this._dict.aggregate(c, builtin);
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            ret = builtin.execute(ret, this._defaultTuple[i]);
        }
        return ret;
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        this._dict.aggregateCols(c, builtin, this._colIndexes);
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c[this._colIndexes.get((int)x)] = builtin.execute(c[this._colIndexes.get(x)], this._defaultTuple[x]);
        }
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowSums(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    protected static final void computeRowSums(double[] c, int rl, int ru, double[] preAgg, AMapToData data, AOffset indexes, int nRows) {
        double def;
        int r;
        block10: {
            r = rl;
            AIterator it = indexes.getIterator(rl);
            def = preAgg[preAgg.length - 1];
            if (it != null) {
                if (it.value() > ru) {
                    indexes.cacheIterator(it, ru);
                } else {
                    if (ru > indexes.getOffsetToLast()) {
                        int maxId = data.size() - 1;
                        while (true) {
                            if (it.value() == r) {
                                int n = r++;
                                c[n] = c[n] + preAgg[data.getIndex(it.getDataIndex())];
                                if (it.getDataIndex() >= maxId) break block10;
                                it.next();
                            } else {
                                int n = r;
                                c[n] = c[n] + def;
                            }
                            ++r;
                        }
                    }
                    while (r < ru) {
                        if (it.value() == r) {
                            int n = r++;
                            c[n] = c[n] + preAgg[data.getIndex(it.getDataIndex())];
                            it.next();
                            continue;
                        }
                        int n = r++;
                        c[n] = c[n] + def;
                    }
                    indexes.cacheIterator(it, ru);
                }
            }
        }
        while (r < ru) {
            int n = r++;
            c[n] = c[n] + def;
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowMxx(c, builtin, rl, ru, preAgg, this._data, this._indexes, this._numRows, preAgg[preAgg.length - 1]);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg, AMapToData data, AOffset indexes, int nRows, double def) {
        int r;
        block7: {
            AIterator it;
            block9: {
                block8: {
                    it = indexes.getIterator(rl);
                    if (it == null) break block7;
                    if (it.value() <= ru) break block8;
                    indexes.cacheIterator(it, ru);
                    break block7;
                }
                if (ru <= indexes.getOffsetToLast()) break block9;
                int maxId = data.size() - 1;
                while (true) {
                    block11: {
                        block10: {
                            if (it.value() != r) break block10;
                            c[r] = builtin.execute(c[r], preAgg[data.getIndex(it.getDataIndex())]);
                            if (it.getDataIndex() < maxId) {
                                it.next();
                                break block11;
                            } else {
                                ++r;
                                break block7;
                            }
                        }
                        c[r] = builtin.execute(c[r], def);
                    }
                    ++r;
                }
            }
            for (r = rl; r < ru; ++r) {
                if (it.value() == r) {
                    c[r] = builtin.execute(c[r], preAgg[data.getIndex(it.getDataIndex())]);
                    it.next();
                    continue;
                }
                c[r] = builtin.execute(c[r], def);
            }
            indexes.cacheIterator(it, ru);
        }
        while (r < ru) {
            c[r] = builtin.execute(c[r], def);
            ++r;
        }
        return;
    }

    @Override
    protected void computeSum(double[] c, int nRows) {
        super.computeSum(c, nRows);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._defaultTuple.length; ++x) {
            c[0] = c[0] + this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        super.computeColSums(c, nRows);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            int n = this._colIndexes.get(x);
            c[n] = c[n] + this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeSumSq(double[] c, int nRows) {
        super.computeSumSq(c, nRows);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c[0] = c[0] + this._defaultTuple[x] * this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeColSumsSq(double[] c, int nRows) {
        super.computeColSumsSq(c, nRows);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            int n = this._colIndexes.get(x);
            c[n] = c[n] + this._defaultTuple[x] * this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        int count = this._numRows - this._data.size();
        this._dict.productWithDefault(c, this.getCounts(), this._defaultTuple, count);
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        super.computeColProduct(c, nRows);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            double v = c[this._colIndexes.get(x)];
            c[this._colIndexes.get((int)x)] = v != 0.0 ? v * Math.pow(this._defaultTuple[x], count) : 0.0;
        }
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowProduct(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    protected static final void computeRowProduct(double[] c, int rl, int ru, double[] preAgg, AMapToData data, AOffset indexes, int nRows) {
        int r;
        double def;
        block10: {
            AIterator it = indexes.getIterator(rl);
            def = preAgg[preAgg.length - 1];
            if (it != null) {
                if (it.value() > ru) {
                    indexes.cacheIterator(it, ru);
                } else {
                    if (ru > indexes.getOffsetToLast()) {
                        int maxId = data.size() - 1;
                        while (true) {
                            if (it.value() == r) {
                                int n = r++;
                                c[n] = c[n] * preAgg[data.getIndex(it.getDataIndex())];
                                if (it.getDataIndex() >= maxId) break block10;
                                it.next();
                            } else {
                                int n = r;
                                c[n] = c[n] * def;
                            }
                            ++r;
                        }
                    }
                    for (r = rl; r < ru; ++r) {
                        if (it.value() == r) {
                            int n = r;
                            c[n] = c[n] * preAgg[data.getIndex(it.getDataIndex())];
                            it.next();
                            continue;
                        }
                        int n = r;
                        c[n] = c[n] * def;
                    }
                    indexes.cacheIterator(it, ru);
                }
            }
        }
        while (r < ru) {
            int n = r++;
            c[n] = c[n] * def;
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this._data.getCounts(counts);
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        long c = super.getNumberNonZeros(nRows);
        int count = this._numRows - this._data.size();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c += this._defaultTuple[x] != 0.0 ? (long)count : 0L;
        }
        return c;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        size += this._data.getInMemorySize();
        return size += (long)(8 * this._colIndexes.size());
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.executeScalar(this._defaultTuple[i]);
        }
        ADictionary nDict = this._dict.applyScalarOp(op);
        return ColGroupSDC.create(this._colIndexes, this._numRows, nDict, newDefaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(this._defaultTuple[i]);
        }
        ADictionary nDict = this._dict.applyUnaryOp(op);
        return ColGroupSDC.create(this._colIndexes, this._numRows, nDict, newDefaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(v[this._colIndexes.get(i)], this._defaultTuple[i]);
        }
        ADictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, newDefaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(this._defaultTuple[i], v[this._colIndexes.get(i)]);
        }
        ADictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, newDefaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        this._data.write(out);
        for (double d : this._defaultTuple) {
            out.writeDouble(d);
        }
    }

    public static ColGroupSDC read(DataInput in, int nRows) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        ADictionary dict = DictionaryFactory.read(in);
        AOffset indexes = OffsetFactory.readIn(in);
        AMapToData data = MapToFactory.readIn(in);
        double[] defaultTuple = ColGroupIO.readDoubleArray(cols.size(), in);
        return new ColGroupSDC(cols, nRows, dict, defaultTuple, indexes, data, null);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._data.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += (long)(8 * this._colIndexes.size());
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.size());
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = this._defaultTuple[i] == pattern ? replace : this._defaultTuple[i];
        }
        return ColGroupSDC.create(this._colIndexes, this._numRows, replaced, newDefaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup extractCommon(double[] constV) {
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            int n = this._colIndexes.get(i);
            constV[n] = constV[n] + this._defaultTuple[i];
        }
        ADictionary subtractedDict = this._dict.subtractTuple(this._defaultTuple);
        return ColGroupSDCZeros.create(this._colIndexes, this._numRows, subtractedDict, this._indexes, this._data, this.getCounts());
    }

    public AColGroup subtractDefaultTuple() {
        ADictionary subtractedDict = this._dict.subtractTuple(this._defaultTuple);
        return ColGroupSDCZeros.create(this._colIndexes, this._numRows, subtractedDict, this._indexes, this._data, this.getCounts());
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        return this._dict.centralMomentWithDefault(op.fn, this.getCounts(), this._defaultTuple[0], nRows);
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        ADictionary d = this._dict.rexpandCols(max, ignore, cast, this._colIndexes.size());
        return ColGroupSDC.rexpandCols(max, ignore, cast, nRows, d, this._indexes, this._data, this.getCachedCounts(), (int)this._defaultTuple[0]);
    }

    protected static AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows, ADictionary d, AOffset indexes, AMapToData data, int[] counts, int def) {
        if (d == null) {
            if (def <= 0 || def > max) {
                return ColGroupEmpty.create(max);
            }
            double[] retDef = new double[max];
            retDef[def - 1] = 1.0;
            return ColGroupSDCSingle.create(ColIndexFactory.create(max), nRows, Dictionary.create(new double[max]), retDef, indexes, null);
        }
        IColIndex outCols = ColIndexFactory.create(max);
        if (def <= 0) {
            if (ignore) {
                return ColGroupSDCZeros.create(outCols, nRows, d, indexes, data, counts);
            }
            throw new DMLRuntimeException("Invalid content of zero in rexpand");
        }
        if (def > max) {
            return ColGroupSDCZeros.create(outCols, nRows, d, indexes, data, counts);
        }
        double[] retDef = new double[max];
        retDef[def - 1] = 1.0;
        return ColGroupSDC.create(outCols, nRows, d, retDef, indexes, data, counts);
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this._data.size();
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, IColIndex outputCols) {
        ADictionary retDict = this._dict.sliceOutColumnRange(idStart, idEnd, this._colIndexes.size());
        double[] newDef = new double[idEnd - idStart];
        int i = idStart;
        int j = 0;
        while (i < idEnd) {
            newDef[j] = this._defaultTuple[i];
            ++i;
            ++j;
        }
        return ColGroupSDC.create(outputCols, this._numRows, retDict, newDef, this._indexes, this._data, this.getCounts());
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        IColIndex retIndexes = ColIndexFactory.create(1);
        if (this._colIndexes.size() == 1) {
            return ColGroupSDC.create(retIndexes, this._numRows, this._dict, this._defaultTuple, this._indexes, this._data, this.getCounts());
        }
        double[] newDef = new double[]{this._defaultTuple[idx]};
        ADictionary retDict = this._dict.sliceOutColumnRange(idx, idx + 1, this._colIndexes.size());
        return ColGroupSDC.create(retIndexes, this._numRows, retDict, newDef, this._indexes, this._data, this.getCounts());
    }

    @Override
    public boolean containsValue(double pattern) {
        if (this._dict.containsValue(pattern)) {
            return true;
        }
        for (double v : this._defaultTuple) {
            if (v != pattern) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] getCommon() {
        return this._defaultTuple;
    }

    @Override
    protected AColGroup allocateRightMultiplicationCommon(double[] common, IColIndex colIndexes, ADictionary preAgg) {
        return ColGroupSDC.create(colIndexes, this._numRows, preAgg, common, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        if (ru > this._numRows) {
            throw new DMLRuntimeException("Invalid row range");
        }
        AOffset.OffsetSliceInfo off = this._indexes.slice(rl, ru);
        if (off.lIndex == -1) {
            return ColGroupConst.create(this._colIndexes, (ADictionary)Dictionary.create(this._defaultTuple));
        }
        AMapToData newData = this._data.slice(off.lIndex, off.uIndex);
        return ColGroupSDC.create(this._colIndexes, ru - rl, this._dict, this._defaultTuple, off.offsetSlice, newData, null);
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, ADictionary newDictionary) {
        return ColGroupSDC.create(colIndexes, this._numRows, newDictionary, this._defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        if (g instanceof ColGroupSDC && g.getColIndices().equals(this._colIndexes)) {
            ColGroupSDC gSDC = (ColGroupSDC)g;
            if (Arrays.equals(this._defaultTuple, gSDC._defaultTuple) && gSDC._dict.equals(this._dict)) {
                AMapToData nd = this._data.append(gSDC._data);
                AOffset ofd = this._indexes.append(gSDC._indexes, this.getNumRows());
                return ColGroupSDC.create(this._colIndexes, this._numRows + gSDC._numRows, this._dict, this._defaultTuple, ofd, nd, null);
            }
        }
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g) {
        int sumRows = this.getNumRows();
        for (int i = 1; i < g.length; ++i) {
            if (!this._colIndexes.equals(g[i]._colIndexes)) {
                LOG.warn((Object)("Not same columns therefore not appending \n" + this._colIndexes + "\n\n" + g[i]._colIndexes));
                return null;
            }
            if (!(g[i] instanceof ColGroupSDC)) {
                LOG.warn((Object)("Not SDC but " + g[i].getClass().getSimpleName()));
                return null;
            }
            ColGroupSDC gc = (ColGroupSDC)g[i];
            if (!gc._dict.equals(this._dict)) {
                LOG.warn((Object)("Not same Dictionaries therefore not appending \n" + this._dict + "\n\n" + gc._dict));
                return null;
            }
            sumRows += gc.getNumRows();
        }
        AMapToData nd = this._data.appendN((AMapToDataGroup[])Arrays.copyOf(g, g.length, AMapToDataGroup[].class));
        AOffset no = this._indexes.appendN((AOffsetsGroup[])Arrays.copyOf(g, g.length, AOffsetsGroup[].class), this.getNumRows());
        return ColGroupSDC.create(this._colIndexes, sumRows, this._dict, this._defaultTuple, no, nd, null);
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Default: "));
        sb.append(Arrays.toString(this._defaultTuple));
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this._data.toString());
        return sb.toString();
    }
}

