/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class DoubleArray
extends Array<Double> {
    private double[] _data;

    public DoubleArray(double[] data) {
        super(data.length);
        this._data = data;
    }

    public double[] get() {
        return this._data;
    }

    @Override
    public Double get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, Double value) {
        this._data[index] = value != null ? value : 0.0;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = value;
    }

    @Override
    public void set(int index, String value) {
        this.set(index, DoubleArray.parseDouble(value));
    }

    @Override
    public void set(int rl, int ru, Array<Double> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = UtilFunctions.objectToDouble(vt, value.get(i));
        }
    }

    @Override
    public void set(int rl, int ru, Array<Double> value, int rlSrc) {
        System.arraycopy(((DoubleArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
    }

    @Override
    public void setNz(int rl, int ru, Array<Double> value) {
        double[] data2 = ((DoubleArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == 0.0) continue;
            this._data[i] = data2[i];
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            double v = UtilFunctions.objectToDouble(vt, value.get(i));
            if (v == 0.0) continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(DoubleArray.parseDouble(value));
    }

    @Override
    public void append(Double value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value : 0.0;
    }

    @Override
    public Array<Double> append(Array<Double> other) {
        int endSize = this._size + other.size();
        double[] ret = new double[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy((double[])other.get(), 0, ret, this._size, other.size());
        if (other instanceof OptionalArray) {
            return OptionalArray.appendOther((OptionalArray)other, new DoubleArray(ret));
        }
        return new DoubleArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.FP64.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeDouble(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readDouble();
        }
    }

    @Override
    public Array<Double> clone() {
        return new DoubleArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Double> slice(int rl, int ru) {
        return new DoubleArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new double[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0.0;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer doubleBuffer = ByteBuffer.allocate(8 * this._size);
        doubleBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < this._size; ++i) {
            doubleBuffer.putDouble(this._data[i]);
        }
        return doubleBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.FP64;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType() {
        Types.ValueType state = FrameUtil.isType(this._data[0]);
        block17: for (int i = 0; i < this._size; ++i) {
            Types.ValueType c = FrameUtil.isType(this._data[i], state);
            if (state == Types.ValueType.FP64) {
                return new Pair<Types.ValueType, Boolean>(Types.ValueType.FP64, false);
            }
            switch (state) {
                case FP32: {
                    switch (c) {
                        case FP64: {
                            state = c;
                        }
                    }
                    continue block17;
                }
                case INT64: {
                    switch (c) {
                        case FP64: 
                        case FP32: {
                            state = c;
                        }
                    }
                    continue block17;
                }
                case INT32: {
                    switch (c) {
                        case FP64: 
                        case FP32: 
                        case INT64: {
                            state = c;
                        }
                    }
                    continue block17;
                }
                default: {
                    switch (c) {
                        case FP64: 
                        case FP32: 
                        case INT64: 
                        case INT32: {
                            state = c;
                        }
                    }
                }
            }
        }
        return new Pair<Types.ValueType, Boolean>(state, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.FP64;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.doubleArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 8 * this._data.length;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != 0.0 && this._data[i] != 1.0) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0.0);
        }
        return new BitSetArray(ret, this.size());
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != 0.0 && this._data[i] != 1.0) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0.0;
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        return this;
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        float[] ret = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = (float)this._data[i];
        }
        return new FloatArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != (double)((int)this._data[i])) {
                throw new DMLRuntimeException("Unable to change to Integer from Double array because of value:" + this._data[i]);
            }
            ret[i] = (int)this._data[i];
        }
        return new IntegerArray(ret);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != (double)((long)this._data[i])) {
                throw new DMLRuntimeException("Unable to change to Long from Double array because of value:" + this._data[i]);
            }
            ret[i] = (long)this._data[i];
        }
        return new LongArray(ret);
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString();
        }
        return new StringArray(ret);
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = CharArray.parseChar(this.get(i).toString());
        }
        return new CharArray(ret);
    }

    @Override
    public void fill(String value) {
        this.fill(DoubleArray.parseDouble(value));
    }

    @Override
    public void fill(Double value) {
        value = value != null ? value : 0.0;
        Arrays.fill(this._data, value);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static double parseDouble(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._data.length; ++i) {
            if (!this.isNotEmpty(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Double> select(int[] indices) {
        double[] ret = new double[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new DoubleArray(ret);
    }

    @Override
    public Array<Double> select(boolean[] select, int nTrue) {
        double[] ret = new double[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new DoubleArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._data.length * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

