/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageCodegenItem;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class SpoofCPInstruction
extends ComputationCPInstruction {
    protected static final Log LOG = LogFactory.getLog((String)SpoofCPInstruction.class.getName());
    private final Class<?> _class;
    private final SpoofOperator _op;
    private final int _numThreads;
    private final CPOperand[] _in;

    private SpoofCPInstruction(SpoofOperator op, Class<?> cla, int k, CPOperand[] in, CPOperand out, String opcode, String str) {
        super(CPInstruction.CPType.SpoofFused, null, null, null, out, opcode, str);
        this._class = cla;
        this._op = op;
        this._numThreads = k;
        this._in = in;
    }

    public SpoofOperator getSpoofOperator() {
        return this._op;
    }

    public Class<?> getOperatorClass() {
        return this._class;
    }

    public static SpoofCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> inlist = new ArrayList<CPOperand>();
        Class<?> cla = CodegenUtils.getClass(parts[2]);
        SpoofOperator op = CodegenUtils.createInstance(cla);
        String opcode = parts[0] + op.getSpoofType();
        for (int i = 3; i < parts.length - 2; ++i) {
            inlist.add(new CPOperand(parts[i]));
        }
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        int k = Integer.parseInt(parts[parts.length - 1]);
        return new SpoofCPInstruction(op, cla, k, inlist.toArray(new CPOperand[0]), out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        Serializable out;
        ArrayList<MatrixBlock> inputs = new ArrayList<MatrixBlock>();
        ArrayList<ScalarObject> scalars = new ArrayList<ScalarObject>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("executing spoof instruction " + this._op));
        }
        for (CPOperand input : this._in) {
            if (input.getDataType() == Types.DataType.MATRIX) {
                MatrixBlock mb = ec.getMatrixInput(input.getName());
                if (mb instanceof CompressedMatrixBlock) {
                    mb = ((CompressedMatrixBlock)mb).getUncompressed("Spoof instruction");
                }
                inputs.add(mb);
                continue;
            }
            if (input.getDataType() != Types.DataType.SCALAR) continue;
            scalars.add(ec.getScalarInput(input));
        }
        if (this.output.getDataType() == Types.DataType.MATRIX) {
            out = this._op.execute(inputs, scalars, new MatrixBlock(), this._numThreads);
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)out);
        } else if (this.output.getDataType() == Types.DataType.SCALAR) {
            out = this._op.execute(inputs, scalars, this._numThreads);
            ec.setScalarOutput(this.output.getName(), (ScalarObject)out);
        }
        for (CPOperand input : this._in) {
            if (input.getDataType() != Types.DataType.MATRIX) continue;
            ec.releaseMatrixInput(input.getName());
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        LineageItem li = ec.getLineage().get(this.output.getName());
        if (li != null) {
            return Pair.of((Object)this.output.getName(), (Object)li);
        }
        LineageItem LIroot = LineageCodegenItem.getCodegenLTrace(this.getOperatorClass().getName()).deepCopy();
        LineageItemUtils.replaceDagLeaves(ec, LIroot, this._in);
        return Pair.of((Object)this.output.getName(), (Object)LIroot);
    }

    @Override
    public CPOperand[] getInputs() {
        return this._in;
    }
}

