/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;

public class OperationsOnMatrixValues {
    public static void performReorg(MatrixIndexes indexesIn, MatrixValue valueIn, MatrixIndexes indexesOut, MatrixValue valueOut, ReorgOperator op, int startRow, int startColumn, int length) {
        op.fn.execute(indexesIn, indexesOut);
        valueIn.reorgOperations(op, valueOut, startRow, startColumn, length);
    }

    public static void performAppend(MatrixValue valueIn1, MatrixValue valueIn2, ArrayList<IndexedMatrixValue> outlist, int blen, boolean cbind, boolean m2IsLast, int nextNCol) {
        valueIn1.append(valueIn2, outlist, blen, cbind, m2IsLast, nextNCol);
    }

    public static void performZeroOut(MatrixIndexes indexesIn, MatrixValue valueIn, MatrixIndexes indexesOut, MatrixValue valueOut, IndexRange range, boolean complementary) {
        valueIn.zeroOutOperations(valueOut, range, complementary);
        indexesOut.setIndexes(indexesIn);
    }

    public static void performCtable(MatrixIndexes indexesIn1, MatrixValue valueIn1, MatrixIndexes indexesIn2, MatrixValue valueIn2, MatrixIndexes indexesIn3, MatrixValue valueIn3, CTableMap resultMap, MatrixBlock resultBlock, Operator op) {
        valueIn1.ctableOperations(op, valueIn2, valueIn3, resultMap, resultBlock);
    }

    public static void performCtable(MatrixIndexes indexesIn1, MatrixValue valueIn1, MatrixIndexes indexesIn2, MatrixValue valueIn2, double scalarIn3, CTableMap resultMap, MatrixBlock resultBlock, Operator op) {
        valueIn1.ctableOperations(op, valueIn2, scalarIn3, false, resultMap, resultBlock);
    }

    public static void performCtable(MatrixIndexes indexesIn1, MatrixValue valueIn1, double scalarIn2, double scalarIn3, CTableMap resultMap, MatrixBlock resultBlock, Operator op) {
        valueIn1.ctableOperations(op, scalarIn2, scalarIn3, resultMap, resultBlock);
    }

    public static void performCtable(MatrixIndexes indexesIn1, MatrixValue valueIn1, double scalarIn2, boolean left, int blen, CTableMap resultMap, MatrixBlock resultBlock, Operator op) {
        valueIn1.ctableOperations(op, indexesIn1, scalarIn2, left, blen, resultMap, resultBlock);
    }

    public static void performCtable(MatrixIndexes indexesIn1, MatrixValue valueIn1, double scalarIn2, MatrixIndexes indexesIn3, MatrixValue valueIn3, CTableMap resultMap, MatrixBlock resultBlock, Operator op) {
        valueIn1.ctableOperations(op, scalarIn2, valueIn3, resultMap, resultBlock);
    }

    public static void performBinaryIgnoreIndexes(MatrixValue value1, MatrixValue value2, MatrixValue valueOut, BinaryOperator op) {
        value1.binaryOperations(op, value2, valueOut);
    }

    public static void startAggregation(MatrixValue valueOut, MatrixValue correction, AggregateOperator op, int rlen, int clen, boolean sparseHint, boolean embeddedCorrection) {
        block18: {
            block15: {
                int corCol;
                int corRow;
                int outCol;
                int outRow;
                block17: {
                    block16: {
                        outRow = 0;
                        outCol = 0;
                        corRow = 0;
                        corCol = 0;
                        if (embeddedCorrection && !op.existsCorrection()) break block15;
                        if (embeddedCorrection) break block16;
                        switch (op.correction) {
                            case NONE: {
                                outRow = rlen;
                                outCol = clen;
                                corRow = rlen;
                                corCol = clen;
                                break block17;
                            }
                            case LASTROW: {
                                outRow = rlen - 1;
                                outCol = clen;
                                corRow = 1;
                                corCol = clen;
                                break block17;
                            }
                            case LASTCOLUMN: {
                                if (op.increOp.fn instanceof Builtin && (((Builtin)op.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX || ((Builtin)op.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX)) {
                                    outRow = rlen;
                                    outCol = 1;
                                    corRow = rlen;
                                    corCol = 1;
                                } else {
                                    outRow = rlen;
                                    outCol = clen - 1;
                                    corRow = rlen;
                                    corCol = 1;
                                }
                                break block17;
                            }
                            case LASTTWOROWS: {
                                outRow = rlen - 2;
                                outCol = clen;
                                corRow = 2;
                                corCol = clen;
                                break block17;
                            }
                            case LASTTWOCOLUMNS: {
                                outRow = rlen;
                                outCol = clen - 2;
                                corRow = rlen;
                                corCol = 2;
                                break block17;
                            }
                            case LASTFOURROWS: {
                                outRow = rlen - 4;
                                outCol = clen;
                                corRow = 4;
                                corCol = clen;
                                break block17;
                            }
                            case LASTFOURCOLUMNS: {
                                outRow = rlen;
                                outCol = clen - 4;
                                corRow = rlen;
                                corCol = 4;
                                break block17;
                            }
                            default: {
                                throw new DMLRuntimeException("unrecognized correctionLocation: " + op.correction);
                            }
                        }
                    }
                    outRow = rlen;
                    outCol = clen;
                    corRow = rlen;
                    corCol = clen;
                }
                if (op.initialValue == 0.0) {
                    valueOut.reset(Math.max(outRow, 0), Math.max(outCol, 0), sparseHint);
                    correction.reset(Math.max(corRow, 0), Math.max(corCol, 0), false);
                } else {
                    valueOut.reset(Math.max(outRow, 0), Math.max(outCol, 0), op.initialValue);
                    correction.reset(Math.max(corRow, 0), Math.max(corCol, 0), op.initialValue);
                }
                break block18;
            }
            if (op.initialValue == 0.0) {
                valueOut.reset(rlen, clen, sparseHint);
            } else {
                valueOut.reset(rlen, clen, op.initialValue);
            }
        }
    }

    public static void incrementalAggregation(MatrixValue valueAgg, MatrixValue correction, MatrixValue valueAdd, AggregateOperator op, boolean embeddedCorrection) {
        OperationsOnMatrixValues.incrementalAggregation(valueAgg, correction, valueAdd, op, embeddedCorrection, true);
    }

    public static void incrementalAggregation(MatrixValue valueAgg, MatrixValue correction, MatrixValue valueAdd, AggregateOperator op, boolean embeddedCorrection, boolean deep) {
        if (!embeddedCorrection || op.existsCorrection()) {
            if (op.correction == Types.CorrectionLocationType.NONE) {
                valueAgg.incrementalAggregate(op, correction, valueAdd, deep);
            } else {
                valueAgg.incrementalAggregate(op, valueAdd);
            }
        } else {
            valueAgg.binaryOperationsInPlace(op.increOp, valueAdd);
        }
    }

    public static void performAggregateUnary(MatrixIndexes indexesIn, MatrixValue valueIn, MatrixIndexes indexesOut, MatrixValue valueOut, AggregateUnaryOperator op, int blen) {
        op.indexFn.execute(indexesIn, indexesOut);
        valueIn.aggregateUnaryOperations(op, valueOut, blen, indexesIn);
    }

    public static MatrixBlock matMult(MatrixIndexes indexes1, MatrixBlock value1, MatrixIndexes indexes2, MatrixBlock value2, MatrixIndexes indexesOut, MatrixBlock valueOut, AggregateBinaryOperator op) {
        indexesOut.setIndexes(indexes1.getRowIndex(), indexes2.getColumnIndex());
        if (value2 instanceof CompressedMatrixBlock) {
            return value2.aggregateBinaryOperations(value1, value2, valueOut, op);
        }
        return value1.aggregateBinaryOperations(value1, value2, valueOut, op);
    }

    public static MatrixBlock matMult(MatrixBlock value1, MatrixBlock value2, AggregateBinaryOperator op) {
        if (value2 instanceof CompressedMatrixBlock) {
            return value2.aggregateBinaryOperations(value1, value2, op);
        }
        return value1.aggregateBinaryOperations(value1, value2, op);
    }

    public static MatrixBlock matMult(MatrixBlock value1, MatrixBlock value2, MatrixBlock valueOut, AggregateBinaryOperator op) {
        if (value2 instanceof CompressedMatrixBlock) {
            return value2.aggregateBinaryOperations(value1, value2, valueOut, op);
        }
        return value1.aggregateBinaryOperations(value1, value2, valueOut, op);
    }

    public static List performSlice(IndexRange ixrange, int blen, int iix, int jix, CacheBlock in) {
        if (in instanceof MatrixBlock) {
            return OperationsOnMatrixValues.performSlice(ixrange, blen, iix, jix, (MatrixBlock)in);
        }
        if (in instanceof FrameBlock) {
            return OperationsOnMatrixValues.performSlice(ixrange, blen, iix, jix, (FrameBlock)in);
        }
        throw new DMLRuntimeException("Unsupported cache block type: " + in.getClass().getName());
    }

    public static List performSlice(IndexRange ixrange, int blen, int iix, int jix, MatrixBlock in) {
        IndexedMatrixValue imv = new IndexedMatrixValue(new MatrixIndexes(iix, jix), in);
        ArrayList<IndexedMatrixValue> outlist = OperationsOnMatrixValues.performSlice(imv, ixrange, blen);
        return SparkUtils.fromIndexedMatrixBlockToPair(outlist);
    }

    public static ArrayList<IndexedMatrixValue> performSlice(IndexedMatrixValue in, IndexRange ixrange, int blen) {
        int colsInLastBlock;
        ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>();
        long cellIndexTopRow = UtilFunctions.computeCellIndex(in.getIndexes().getRowIndex(), blen, 0);
        long cellIndexBottomRow = UtilFunctions.computeCellIndex(in.getIndexes().getRowIndex(), blen, in.getValue().getNumRows() - 1);
        long cellIndexLeftCol = UtilFunctions.computeCellIndex(in.getIndexes().getColumnIndex(), blen, 0);
        long cellIndexRightCol = UtilFunctions.computeCellIndex(in.getIndexes().getColumnIndex(), blen, in.getValue().getNumColumns() - 1);
        long cellIndexOverlapTop = Math.max(cellIndexTopRow, ixrange.rowStart);
        long cellIndexOverlapBottom = Math.min(cellIndexBottomRow, ixrange.rowEnd);
        long cellIndexOverlapLeft = Math.max(cellIndexLeftCol, ixrange.colStart);
        long cellIndexOverlapRight = Math.min(cellIndexRightCol, ixrange.colEnd);
        if (cellIndexOverlapTop > cellIndexOverlapBottom || cellIndexOverlapLeft > cellIndexOverlapRight) {
            return outlist;
        }
        IndexRange tmpRange = new IndexRange(UtilFunctions.computeCellInBlock(cellIndexOverlapTop, blen), UtilFunctions.computeCellInBlock(cellIndexOverlapBottom, blen), UtilFunctions.computeCellInBlock(cellIndexOverlapLeft, blen), UtilFunctions.computeCellInBlock(cellIndexOverlapRight, blen));
        int rowCut = UtilFunctions.computeCellInBlock(ixrange.rowStart, blen);
        int colCut = UtilFunctions.computeCellInBlock(ixrange.colStart, blen);
        int rowsInLastBlock = (int)((ixrange.rowEnd - ixrange.rowStart + 1L) % (long)blen);
        if (rowsInLastBlock == 0) {
            rowsInLastBlock = blen;
        }
        if ((colsInLastBlock = (int)((ixrange.colEnd - ixrange.colStart + 1L) % (long)blen)) == 0) {
            colsInLastBlock = blen;
        }
        long resultBlockIndexTop = UtilFunctions.computeBlockIndex(cellIndexOverlapTop - ixrange.rowStart + 1L, blen);
        long resultBlockIndexBottom = UtilFunctions.computeBlockIndex(cellIndexOverlapBottom - ixrange.rowStart + 1L, blen);
        long resultBlockIndexLeft = UtilFunctions.computeBlockIndex(cellIndexOverlapLeft - ixrange.colStart + 1L, blen);
        long resultBlockIndexRight = UtilFunctions.computeBlockIndex(cellIndexOverlapRight - ixrange.colStart + 1L, blen);
        int boundaryRlen = blen;
        int boundaryClen = blen;
        long finalBlockIndexBottom = UtilFunctions.computeBlockIndex(ixrange.rowEnd - ixrange.rowStart + 1L, blen);
        long finalBlockIndexRight = UtilFunctions.computeBlockIndex(ixrange.colEnd - ixrange.colStart + 1L, blen);
        if (resultBlockIndexBottom == finalBlockIndexBottom) {
            boundaryRlen = rowsInLastBlock;
        }
        if (resultBlockIndexRight == finalBlockIndexRight) {
            boundaryClen = colsInLastBlock;
        }
        for (long r = resultBlockIndexTop; r <= resultBlockIndexBottom; ++r) {
            for (long c = resultBlockIndexLeft; c <= resultBlockIndexRight; ++c) {
                IndexedMatrixValue out = new IndexedMatrixValue(new MatrixIndexes(), new MatrixBlock());
                out.getIndexes().setIndexes(r, c);
                outlist.add(out);
            }
        }
        in.getValue().slice(outlist, tmpRange, rowCut, colCut, blen, boundaryRlen, boundaryClen);
        return outlist;
    }

    public static void performShift(IndexedMatrixValue in, IndexRange ixrange, int blen, long rlen, long clen, ArrayList<IndexedMatrixValue> outlist) {
        MatrixIndexes ix = in.getIndexes();
        MatrixBlock mb = (MatrixBlock)in.getValue();
        long start_lhs_globalRowIndex = ixrange.rowStart + (ix.getRowIndex() - 1L) * (long)blen;
        long start_lhs_globalColIndex = ixrange.colStart + (ix.getColumnIndex() - 1L) * (long)blen;
        long end_lhs_globalRowIndex = start_lhs_globalRowIndex + (long)mb.getNumRows() - 1L;
        long end_lhs_globalColIndex = start_lhs_globalColIndex + (long)mb.getNumColumns() - 1L;
        long start_lhs_rowIndex = UtilFunctions.computeBlockIndex(start_lhs_globalRowIndex, blen);
        long end_lhs_rowIndex = UtilFunctions.computeBlockIndex(end_lhs_globalRowIndex, blen);
        long start_lhs_colIndex = UtilFunctions.computeBlockIndex(start_lhs_globalColIndex, blen);
        long end_lhs_colIndex = UtilFunctions.computeBlockIndex(end_lhs_globalColIndex, blen);
        for (long leftRowIndex = start_lhs_rowIndex; leftRowIndex <= end_lhs_rowIndex; ++leftRowIndex) {
            for (long leftColIndex = start_lhs_colIndex; leftColIndex <= end_lhs_colIndex; ++leftColIndex) {
                long lhs_rl = Math.max((leftRowIndex - 1L) * (long)blen + 1L, start_lhs_globalRowIndex);
                long lhs_ru = Math.min(leftRowIndex * (long)blen, end_lhs_globalRowIndex);
                long lhs_cl = Math.max((leftColIndex - 1L) * (long)blen + 1L, start_lhs_globalColIndex);
                long lhs_cu = Math.min(leftColIndex * (long)blen, end_lhs_globalColIndex);
                int lhs_lrl = UtilFunctions.computeCellInBlock(lhs_rl, blen);
                int lhs_lru = UtilFunctions.computeCellInBlock(lhs_ru, blen);
                int lhs_lcl = UtilFunctions.computeCellInBlock(lhs_cl, blen);
                int lhs_lcu = UtilFunctions.computeCellInBlock(lhs_cu, blen);
                long rhs_rl = lhs_rl - ixrange.rowStart + 1L;
                long rhs_ru = rhs_rl + (lhs_ru - lhs_rl);
                long rhs_cl = lhs_cl - ixrange.colStart + 1L;
                long rhs_cu = rhs_cl + (lhs_cu - lhs_cl);
                int rhs_lrl = UtilFunctions.computeCellInBlock(rhs_rl, blen);
                int rhs_lru = UtilFunctions.computeCellInBlock(rhs_ru, blen);
                int rhs_lcl = UtilFunctions.computeCellInBlock(rhs_cl, blen);
                int rhs_lcu = UtilFunctions.computeCellInBlock(rhs_cu, blen);
                MatrixBlock slicedRHSBlk = mb.slice(rhs_lrl, rhs_lru, rhs_lcl, rhs_lcu, new MatrixBlock());
                int lbrlen = UtilFunctions.computeBlockSize(rlen, leftRowIndex, blen);
                int lbclen = UtilFunctions.computeBlockSize(clen, leftColIndex, blen);
                MatrixBlock resultBlock = new MatrixBlock(lbrlen, lbclen, false);
                resultBlock = resultBlock.leftIndexingOperations(slicedRHSBlk, lhs_lrl, lhs_lru, lhs_lcl, lhs_lcu, null, MatrixObject.UpdateType.COPY);
                outlist.add(new IndexedMatrixValue(new MatrixIndexes(leftRowIndex, leftColIndex), resultBlock));
            }
        }
    }

    public static void performMapGroupedAggregate(Operator op, IndexedMatrixValue inTarget, MatrixBlock groups, int ngroups, int blen, ArrayList<IndexedMatrixValue> outlist) {
        MatrixIndexes ix = inTarget.getIndexes();
        MatrixBlock target = (MatrixBlock)inTarget.getValue();
        MatrixBlock out = groups.groupedAggOperations(target, null, new MatrixBlock(), ngroups, op);
        if (out.getNumRows() <= blen && out.getNumColumns() <= blen) {
            outlist.add(new IndexedMatrixValue(new MatrixIndexes(1L, ix.getColumnIndex()), out));
        } else {
            for (int blockRow = 0; blockRow < (int)Math.ceil((double)out.getNumRows() / (double)blen); ++blockRow) {
                int maxRow = blockRow * blen + blen < out.getNumRows() ? blen : out.getNumRows() - blockRow * blen;
                int row_offset = blockRow * blen;
                MatrixBlock tmp = out.slice(row_offset, row_offset + maxRow - 1);
                outlist.add(new IndexedMatrixValue(new MatrixIndexes(blockRow + 1, ix.getColumnIndex()), tmp));
            }
        }
    }

    public static ArrayList performSlice(IndexRange ixrange, int blen, int iix, int jix, FrameBlock in) {
        Pair<Long, FrameBlock> lfp = new Pair<Long, FrameBlock>(Long.valueOf((iix - 1) * blen + 1), in);
        ArrayList<Pair<Long, FrameBlock>> outlist = OperationsOnMatrixValues.performSlice(lfp, ixrange, blen);
        return outlist;
    }

    public static ArrayList<Pair<Long, FrameBlock>> performSlice(Pair<Long, FrameBlock> in, IndexRange ixrange, int blen) {
        ArrayList<Pair<Long, FrameBlock>> outlist = new ArrayList<Pair<Long, FrameBlock>>();
        long index = in.getKey();
        FrameBlock block = in.getValue();
        long cellIndexTopRow = index;
        long cellIndexBottomRow = index + (long)block.getNumRows() - 1L;
        long cellIndexLeftCol = 1L;
        long cellIndexRightCol = block.getNumColumns();
        long cellIndexOverlapTop = Math.max(cellIndexTopRow, ixrange.rowStart);
        long cellIndexOverlapBottom = Math.min(cellIndexBottomRow, ixrange.rowEnd);
        long cellIndexOverlapLeft = Math.max(cellIndexLeftCol, ixrange.colStart);
        long cellIndexOverlapRight = Math.min(cellIndexRightCol, ixrange.colEnd);
        if (cellIndexOverlapTop > cellIndexOverlapBottom || cellIndexOverlapLeft > cellIndexOverlapRight) {
            return outlist;
        }
        IndexRange tmpRange = new IndexRange(cellIndexOverlapTop - index, cellIndexOverlapBottom - index, cellIndexOverlapLeft - 1L, cellIndexOverlapRight - 1L);
        int rowCut = (int)(ixrange.rowStart - index);
        long resultBlockIndexTop = UtilFunctions.computeBlockIndex(cellIndexOverlapTop, blen);
        long resultBlockIndexBottom = UtilFunctions.computeBlockIndex(cellIndexOverlapBottom, blen);
        for (long r = resultBlockIndexTop; r <= resultBlockIndexBottom; ++r) {
            Types.ValueType[] schema = Arrays.copyOfRange(block.getSchema(), (int)tmpRange.colStart, (int)tmpRange.colEnd + 1);
            long iResultIndex = Math.max((r - 1L) * (long)blen - ixrange.rowStart + 1L, 0L);
            Pair<Long, FrameBlock> out = new Pair<Long, FrameBlock>(iResultIndex + 1L, new FrameBlock(schema));
            outlist.add(out);
        }
        block.slice(outlist, tmpRange, rowCut);
        return outlist;
    }

    public static void performShift(Pair<Long, FrameBlock> in, IndexRange ixrange, int blenLeft, long rlen, long clen, ArrayList<Pair<Long, FrameBlock>> outlist) {
        Long ix = in.getKey();
        FrameBlock fb = in.getValue();
        long start_lhs_globalRowIndex = ixrange.rowStart + (ix - 1L);
        long start_lhs_globalColIndex = ixrange.colStart;
        long end_lhs_globalRowIndex = start_lhs_globalRowIndex + (long)fb.getNumRows() - 1L;
        long end_lhs_globalColIndex = ixrange.colEnd;
        long start_lhs_rowIndex = UtilFunctions.computeBlockIndex(start_lhs_globalRowIndex, blenLeft);
        long end_lhs_rowIndex = UtilFunctions.computeBlockIndex(end_lhs_globalRowIndex, blenLeft);
        for (long leftRowIndex = start_lhs_rowIndex; leftRowIndex <= end_lhs_rowIndex; ++leftRowIndex) {
            long lhs_rl = Math.max((leftRowIndex - 1L) * (long)blenLeft + 1L, start_lhs_globalRowIndex);
            long lhs_ru = Math.min(leftRowIndex * (long)blenLeft, end_lhs_globalRowIndex);
            long lhs_cl = start_lhs_globalColIndex;
            long lhs_cu = end_lhs_globalColIndex;
            int lhs_lrl = UtilFunctions.computeCellInBlock(lhs_rl, blenLeft);
            int lhs_lru = UtilFunctions.computeCellInBlock(lhs_ru, blenLeft);
            int lhs_lcl = (int)lhs_cl - 1;
            int lhs_lcu = (int)lhs_cu - 1;
            long rhs_rl = lhs_rl - (ixrange.rowStart - 1L) - (ix - 1L);
            long rhs_ru = rhs_rl + (lhs_ru - lhs_rl);
            long rhs_cl = lhs_cl - ixrange.colStart + 1L;
            long rhs_cu = rhs_cl + (lhs_cu - lhs_cl);
            int rhs_lrl = UtilFunctions.computeCellInBlock(rhs_rl, fb.getNumRows());
            int rhs_lru = UtilFunctions.computeCellInBlock(rhs_ru, fb.getNumRows());
            int rhs_lcl = (int)rhs_cl - 1;
            int rhs_lcu = (int)rhs_cu - 1;
            FrameBlock slicedRHSBlk = fb.slice(rhs_lrl, rhs_lru, rhs_lcl, rhs_lcu, new FrameBlock());
            int lblen = blenLeft;
            Types.ValueType[] schemaPartialLeft = UtilFunctions.nCopies(lhs_lcl, Types.ValueType.STRING);
            Types.ValueType[] schemaRHS = Arrays.copyOfRange(fb.getSchema(), rhs_lcl, rhs_lcl - lhs_lcl + lhs_lcu + 1);
            Types.ValueType[] schema = UtilFunctions.copyOf(schemaPartialLeft, schemaRHS);
            Types.ValueType[] schemaPartialRight = UtilFunctions.nCopies(lblen - schema.length, Types.ValueType.STRING);
            schema = UtilFunctions.copyOf(schema, schemaPartialRight);
            FrameBlock resultBlock = new FrameBlock(schema);
            int iRHSRows = (int)(leftRowIndex <= rlen / (long)blenLeft ? (long)blenLeft : rlen - rlen / (long)blenLeft * (long)blenLeft);
            resultBlock.ensureAllocatedColumns(iRHSRows);
            resultBlock = resultBlock.leftIndexingOperations(slicedRHSBlk, lhs_lrl, lhs_lru, lhs_lcl, lhs_lcu, new FrameBlock());
            outlist.add(new Pair<Long, FrameBlock>((leftRowIndex - 1L) * (long)blenLeft + 1L, resultBlock));
        }
    }
}

