/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCOO;
import org.apache.sysds.runtime.data.SparseBlockCSC;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockDCSR;
import org.apache.sysds.runtime.data.SparseBlockMCSC;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class SparseBlockFactory {
    protected static final Log LOG = LogFactory.getLog((String)SparseBlockFactory.class.getName());

    public static SparseBlock createSparseBlock(int rlen) {
        return SparseBlockFactory.createSparseBlock(MatrixBlock.DEFAULT_SPARSEBLOCK, rlen);
    }

    public static SparseBlock createSparseBlock(SparseBlock.Type type, int rlen) {
        switch (type) {
            case MCSR: {
                return new SparseBlockMCSR(rlen, -1);
            }
            case CSR: {
                return new SparseBlockCSR(rlen);
            }
            case COO: {
                return new SparseBlockCOO(rlen);
            }
            case DCSR: {
                return new SparseBlockDCSR(rlen);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static SparseBlock createSparseBlock(SparseBlock.Type type, SparseRow row) {
        SparseBlock ret = SparseBlockFactory.createSparseBlock(type, 1);
        ret.set(0, row, true);
        return ret;
    }

    public static SparseBlock copySparseBlock(SparseBlock.Type type, SparseBlock sblock, boolean forceCopy) {
        return SparseBlockFactory.copySparseBlock(type, sblock, forceCopy, 1000);
    }

    public static SparseBlock copySparseBlock(SparseBlock.Type type, SparseBlock sblock, boolean forceCopy, int clen) {
        if (sblock == null) {
            return null;
        }
        if (!forceCopy && SparseBlockFactory.isSparseBlockType(sblock, type)) {
            return sblock;
        }
        switch (type) {
            case MCSR: {
                return new SparseBlockMCSR(sblock);
            }
            case CSR: {
                return new SparseBlockCSR(sblock);
            }
            case COO: {
                return new SparseBlockCOO(sblock);
            }
            case DCSR: {
                return new SparseBlockDCSR(sblock);
            }
            case MCSC: {
                return new SparseBlockMCSC(sblock, clen);
            }
            case CSC: {
                return new SparseBlockCSC(sblock, clen);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static boolean isSparseBlockType(SparseBlock sblock, SparseBlock.Type type) {
        return SparseBlockFactory.getSparseBlockType(sblock) == type;
    }

    public static SparseBlock.Type getSparseBlockType(SparseBlock sblock) {
        return sblock instanceof SparseBlockMCSR ? SparseBlock.Type.MCSR : (sblock instanceof SparseBlockCSR ? SparseBlock.Type.CSR : (sblock instanceof SparseBlockCOO ? SparseBlock.Type.COO : null));
    }

    public static long estimateSizeSparseInMemory(SparseBlock.Type type, long nrows, long ncols, double sparsity) {
        switch (type) {
            case MCSR: {
                return SparseBlockMCSR.estimateSizeInMemory(nrows, ncols, sparsity);
            }
            case CSR: {
                return SparseBlockCSR.estimateSizeInMemory(nrows, ncols, sparsity);
            }
            case CSC: {
                return SparseBlockCSC.estimateSizeInMemory(nrows, ncols, sparsity);
            }
            case COO: {
                return SparseBlockCOO.estimateSizeInMemory(nrows, ncols, sparsity);
            }
            case DCSR: {
                return SparseBlockDCSR.estimateSizeInMemory(nrows, ncols, sparsity);
            }
            case MCSC: {
                return SparseBlockMCSC.estimateSizeInMemory(nrows, ncols, sparsity);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static SparseBlock createIdentityMatrix(int nRowCol) {
        int[] rowPtr = new int[nRowCol + 1];
        int[] colIdx = new int[nRowCol];
        double[] vals = new double[nRowCol];
        int nnz = nRowCol;
        for (int i = 0; i < nRowCol; ++i) {
            rowPtr[i] = i;
            colIdx[i] = i;
            vals[i] = 1.0;
        }
        rowPtr[nRowCol] = nRowCol;
        return new SparseBlockCSR(rowPtr, colIdx, vals, nnz);
    }

    public static SparseBlock createIdentityMatrixWithEmptyRow(int nRowCol) {
        int[] rowPtr = new int[nRowCol + 2];
        int[] colIdx = new int[nRowCol];
        double[] vals = new double[nRowCol];
        int nnz = nRowCol;
        for (int i = 0; i < nRowCol; ++i) {
            rowPtr[i] = i;
            colIdx[i] = i;
            vals[i] = 1.0;
        }
        rowPtr[nRowCol] = nRowCol;
        rowPtr[nRowCol + 1] = nRowCol;
        return new SparseBlockCSR(rowPtr, colIdx, vals, nnz);
    }

    public static SparseBlock createFromArray(double[] valsDense, int nCol, int nnz) {
        int nRow = valsDense.length / nCol;
        if (nnz > 0) {
            int[] rowPtr = new int[nRow + 1];
            int[] colIdx = new int[nnz];
            double[] valsSparse = new double[nnz];
            int off = 0;
            for (int i = 0; i < valsDense.length; ++i) {
                int mod = i % nCol;
                if (mod == 0) {
                    rowPtr[i / nCol] = off;
                }
                if (valsDense[i] == 0.0) continue;
                valsSparse[off] = valsDense[i];
                colIdx[off] = mod;
                ++off;
            }
            rowPtr[rowPtr.length - 1] = off;
            return new SparseBlockCSR(rowPtr, colIdx, valsSparse, nnz);
        }
        return new SparseBlockMCSR(nRow);
    }
}

