/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class CumulativeOffsetBinary
extends Lop {
    private Types.AggOp _op;
    private double _initValue = 0.0;
    private boolean _broadcast = false;

    public CumulativeOffsetBinary(Lop data, Lop offsets, Types.DataType dt, Types.ValueType vt, Types.AggOp op, Types.ExecType et) {
        super(Lop.Type.CumulativeOffsetBinary, dt, vt);
        CumulativeOffsetBinary.checkSupportedOperations(op);
        this._op = op;
        this.init(data, offsets, dt, vt, et);
    }

    public CumulativeOffsetBinary(Lop data, Lop offsets, Types.DataType dt, Types.ValueType vt, double init, boolean broadcast, Types.AggOp op, Types.ExecType et) {
        super(Lop.Type.CumulativeOffsetBinary, dt, vt);
        CumulativeOffsetBinary.checkSupportedOperations(op);
        this._op = op;
        this._initValue = init;
        this._broadcast = broadcast;
        this.init(data, offsets, dt, vt, et);
    }

    private void init(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "CumulativeOffsetBinary";
    }

    private static void checkSupportedOperations(Types.AggOp op) {
        if (op != Types.AggOp.SUM && op != Types.AggOp.PROD && op != Types.AggOp.SUM_PROD && op != Types.AggOp.MIN && op != Types.AggOp.MAX) {
            throw new LopsException("Unsupported aggregate operation type: " + op);
        }
    }

    private String getOpcode() {
        switch (this._op) {
            case SUM: {
                return Opcodes.BCUMOFFKP.toString();
            }
            case PROD: {
                return Opcodes.BCUMOFFM.toString();
            }
            case SUM_PROD: {
                return Opcodes.BCUMOFFPM.toString();
            }
            case MIN: {
                return Opcodes.BCUMOFFMIN.toString();
            }
            case MAX: {
                return Opcodes.BCUMOFFMAX.toString();
            }
        }
        return null;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        String inst = InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.SPARK) {
            inst = InstructionUtils.concatOperands(inst, String.valueOf(this._initValue), String.valueOf(this._broadcast));
        }
        return inst;
    }
}

