/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.cost;

import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.resource.cost.RDDStats;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class VarStats {
    String varName;
    MatrixCharacteristics characteristics;
    long allocatedMemory;
    int refCount;
    int selfRefCount;
    Object[] fileInfo = null;
    RDDStats rddStats = null;

    public VarStats(String name, DataCharacteristics dc) {
        this.varName = name;
        if (dc == null) {
            this.characteristics = null;
            this.allocatedMemory = 0L;
        } else if (dc instanceof MatrixCharacteristics) {
            this.characteristics = (MatrixCharacteristics)dc;
            this.allocatedMemory = -1L;
        } else {
            throw new RuntimeException("Unexpected error: expecting MatrixCharacteristics or null");
        }
        this.refCount = 1;
        this.selfRefCount = 1;
    }

    public boolean isScalar() {
        return this.characteristics == null;
    }

    public long getM() {
        return this.isScalar() ? 1L : this.characteristics.getRows();
    }

    public long getN() {
        return this.isScalar() ? 1L : this.characteristics.getCols();
    }

    public long getNNZ() {
        return this.isScalar() ? 1L : this.characteristics.getNonZerosBound();
    }

    public double getSparsity() {
        return this.isScalar() ? 1.0 : OptimizerUtils.getSparsity(this.characteristics);
    }

    public long getCells() {
        return this.isScalar() ? 1L : (!this.characteristics.dimsKnown() ? -1L : this.characteristics.getLength());
    }

    public long getCellsWithSparsity() {
        if (this.isScalar()) {
            return 1L;
        }
        return (long)((double)this.getCells() * this.getSparsity());
    }

    public boolean isSparse() {
        return !this.isScalar() && MatrixBlock.evalSparseFormatInMemory(this.characteristics);
    }

    public void setAllocatedMemory(long memory) {
        this.allocatedMemory = memory;
    }

    public RDDStats getRddStats() {
        return this.rddStats;
    }

    public void setRddStats(RDDStats rddStats) {
        this.rddStats = rddStats;
    }
}

