/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;

public class MapToUByte
extends MapToByte {
    private static final long serialVersionUID = -2498505439667351828L;

    protected MapToUByte(int size) {
        this(128, size);
    }

    public MapToUByte(int unique, int size) {
        super(Math.min(unique, 128), new byte[size]);
    }

    protected MapToUByte(int unique, byte[] data) {
        super(unique, data);
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.UBYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (byte)v;
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (byte)(v % 128));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.UBYTE.ordinal());
        super.writeBytes(out);
    }

    protected static MapToUByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readByte();
        }
        return new MapToUByte(unique, data);
    }

    @Override
    public void replace(int v, int r) {
        byte cv = (byte)v;
        byte rv = (byte)(r % 128);
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    @Override
    public int getUpperBoundValue() {
        return 127;
    }

    @Override
    public int[] getCounts(int[] ret) {
        int h = this._data.length % 8;
        for (int i = 0; i < h; ++i) {
            byte by = this._data[i];
            ret[by] = ret[by] + 1;
        }
        this.getCountsBy8P(ret, h, this._data.length);
        return ret;
    }

    private void getCountsBy8P(int[] ret, int s, int e) {
        for (int i = s; i < e; i += 8) {
            byte by = this._data[i];
            ret[by] = ret[by] + 1;
            byte by2 = this._data[i + 1];
            ret[by2] = ret[by2] + 1;
            byte by3 = this._data[i + 2];
            ret[by3] = ret[by3] + 1;
            byte by4 = this._data[i + 3];
            ret[by4] = ret[by4] + 1;
            byte by5 = this._data[i + 4];
            ret[by5] = ret[by5] + 1;
            byte by6 = this._data[i + 5];
            ret[by6] = ret[by6] + 1;
            byte by7 = this._data[i + 6];
            ret[by7] = ret[by7] + 1;
            byte by8 = this._data[i + 7];
            ret[by8] = ret[by8] + 1;
        }
    }

    @Override
    protected void decompressToRangeNoOffBy8(double[] c, int r, double[] values) {
        int n = r;
        c[n] = c[n] + values[this._data[r]];
        int n2 = r + 1;
        c[n2] = c[n2] + values[this._data[r + 1]];
        int n3 = r + 2;
        c[n3] = c[n3] + values[this._data[r + 2]];
        int n4 = r + 3;
        c[n4] = c[n4] + values[this._data[r + 3]];
        int n5 = r + 4;
        c[n5] = c[n5] + values[this._data[r + 4]];
        int n6 = r + 5;
        c[n6] = c[n6] + values[this._data[r + 5]];
        int n7 = r + 6;
        c[n7] = c[n7] + values[this._data[r + 6]];
        int n8 = r + 7;
        c[n8] = c[n8] + values[this._data[r + 7]];
    }

    @Override
    public void decompressToRange(double[] c, int rl, int ru, int offR, double[] values) {
        if (offR == 0) {
            this.decompressToRangeNoOff(c, rl, ru, values);
        } else {
            this.decompressToRangeOff(c, rl, ru, offR, values);
        }
    }

    @Override
    public void decompressToRangeOff(double[] c, int rl, int ru, int offR, double[] values) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    @Override
    public void decompressToRangeNoOff(double[] c, int rl, int ru, double[] values) {
        int rc;
        int h = (ru - rl) % 8;
        for (rc = rl; rc < rl + h; ++rc) {
            int n = rc;
            c[n] = c[n] + values[this.getIndex(rc)];
        }
        for (rc = rl + h; rc < ru; rc += 8) {
            this.decompressToRangeNoOffBy8(c, rc, values);
        }
    }

    @Override
    public AMapToData resize(int unique) {
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            MapToBit ret = new MapToBit(unique, size);
            ret.copy(this);
            return ret;
        }
        this.setUnique(unique);
        return this;
    }
}

