/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ACachingMBDictionary;

public abstract class AIdentityDictionary
extends ACachingMBDictionary {
    private static final long serialVersionUID = 5013713435287705877L;
    protected final int nRowCol;
    protected final boolean withEmpty;

    public AIdentityDictionary(int nRowCol) {
        if (nRowCol <= 0) {
            throw new DMLCompressionException("Invalid Identity Dictionary");
        }
        this.nRowCol = nRowCol;
        this.withEmpty = false;
    }

    public AIdentityDictionary(int nRowCol, boolean withEmpty) {
        if (nRowCol <= 0) {
            throw new DMLCompressionException("Invalid Identity Dictionary");
        }
        this.nRowCol = nRowCol;
        this.withEmpty = withEmpty;
    }

    public boolean withEmpty() {
        return this.withEmpty;
    }

    public static long getInMemorySize(int numberColumns) {
        return 16L;
    }

    @Override
    public final boolean containsValue(double pattern) {
        return pattern == 0.0 || pattern == 1.0;
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        return new double[this.nRowCol + (this.withEmpty ? 1 : 0)];
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        double[] ret = new double[this.nRowCol + (this.withEmpty ? 1 : 0) + 1];
        ret[ret.length - 1] = 1.0;
        for (int i = 0; i < defaultTuple.length; ++i) {
            int n = ret.length - 1;
            ret[n] = ret[n] * defaultTuple[i];
        }
        return ret;
    }
}

