/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.template;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.runtime.matrix.data.Pair;

public class TemplateUtil {
    public static Pair<ArrayList<Pair<Long, Integer>>, Long> getTokenIndexOnMultiLineRecords(InputSplit split, TextInputFormat inputFormat, JobConf job, String token) throws IOException {
        RecordReader reader = inputFormat.getRecordReader(split, job, Reporter.NULL);
        LongWritable key = new LongWritable();
        Text value = new Text();
        ArrayList<Pair<Long, Integer>> result = new ArrayList<Pair<Long, Integer>>();
        long ri = 0L;
        while (reader.next((Object)key, (Object)value)) {
            int index;
            String raw = value.toString();
            int fromIndex = 0;
            while ((index = raw.indexOf(token, fromIndex)) != -1) {
                result.add(new Pair<Long, Integer>(ri, index));
                fromIndex = index + token.length();
            }
            ++ri;
        }
        return new Pair<ArrayList<Pair<Long, Integer>>, Long>(result, ri);
    }

    public static int getEndPos(String str, int strLen, int currPos, HashSet<String> endWithValueString) {
        int endPos = strLen;
        for (String d : endWithValueString) {
            int pos = d.length() > 0 ? str.indexOf(d, currPos) : strLen;
            if (pos == -1) continue;
            endPos = Math.min(endPos, pos);
        }
        return endPos;
    }

    public static String getStringChunkOfBufferReader(BufferedReader br, String remainedStr, int chunkSize) {
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            for (int readSize = 0; (str = br.readLine()) != null && readSize < chunkSize; readSize += str.length()) {
                sb.append(str).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sb.length() > 0) {
            if (remainedStr != null && remainedStr.length() > 0) {
                return remainedStr + sb;
            }
            return sb.toString();
        }
        return null;
    }

    protected int getColIndex(HashMap<String, Integer> colKeyPatternMap, String key) {
        return colKeyPatternMap.getOrDefault(key, -1);
    }

    public static class SplitInfo {
        private int nrows;
        private ArrayList<Long> recordIndexBegin = new ArrayList();
        private ArrayList<Long> recordIndexEnd = new ArrayList();
        private ArrayList<Integer> recordPositionBegin = new ArrayList();
        private ArrayList<Integer> recordPositionEnd = new ArrayList();
        private String remainString = "";

        public void addIndexAndPosition(Long beginIndex, Long endIndex, int beginPos, int endPos) {
            this.recordIndexBegin.add(beginIndex);
            this.recordIndexEnd.add(endIndex);
            this.recordPositionBegin.add(beginPos);
            this.recordPositionEnd.add(endPos);
        }

        public int getNrows() {
            return this.nrows;
        }

        public int getListSize() {
            return this.recordIndexBegin.size();
        }

        public void setNrows(int nrows) {
            this.nrows = nrows;
        }

        public String getRemainString() {
            return this.remainString;
        }

        public void setRemainString(String remainString) {
            this.remainString = remainString;
        }

        public Long getRecordIndexBegin(int index) {
            return this.recordIndexBegin.get(index);
        }

        public Long getRecordIndexEnd(int index) {
            return this.recordIndexEnd.get(index);
        }

        public int getRecordPositionBegin(int index) {
            return this.recordPositionBegin.get(index);
        }

        public int getRecordPositionEnd(int index) {
            return this.recordPositionEnd.get(index);
        }
    }

    public static class SplitOffsetInfos {
        private int[] offsetPerSplit = null;
        private int[] lenghtPerSplit = null;
        private SplitInfo[] seqOffsetPerSplit = null;

        public SplitOffsetInfos(int numSplits) {
            this.lenghtPerSplit = new int[numSplits];
            this.offsetPerSplit = new int[numSplits];
            this.seqOffsetPerSplit = new SplitInfo[numSplits];
        }

        public int getLenghtPerSplit(int split) {
            return this.lenghtPerSplit[split];
        }

        public void setLenghtPerSplit(int split, int r) {
            this.lenghtPerSplit[split] = r;
        }

        public int getOffsetPerSplit(int split) {
            return this.offsetPerSplit[split];
        }

        public void setOffsetPerSplit(int split, int o) {
            this.offsetPerSplit[split] = o;
        }

        public SplitInfo getSeqOffsetPerSplit(int split) {
            return this.seqOffsetPerSplit[split];
        }

        public void setSeqOffsetPerSplit(int split, SplitInfo splitInfo) {
            this.seqOffsetPerSplit[split] = splitInfo;
        }
    }
}

