/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.plastic;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.FieldValueProvider;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PropertyValueProvider;

public class PlasticUtils {
    private static final String SETTER_METHOD_NAME = "__propertyValueProvider__set";
    private static final String GETTER_METHOD_NAME = "__propertyValueProvider__get";
    public static final Method TO_STRING = PlasticUtils.getMethod(Object.class, "toString", new Class[0]);
    public static final MethodDescription TO_STRING_DESCRIPTION = new MethodDescription(TO_STRING);
    private static final AtomicLong UID_GENERATOR = new AtomicLong(System.nanoTime());
    private static final MethodDescription PROPERTY_VALUE_PROVIDER_GETTER_METHOD_DESCRIPTION;
    private static final MethodDescription PROPERTY_VALUE_PROVIDER_SETTER_METHOD_DESCRIPTION;
    private static final MethodDescription FIELD_VALUE_PROVIDER_METHOD_DESCRIPTION;

    public static String nextUID() {
        return Long.toHexString(UID_GENERATOR.getAndIncrement());
    }

    public static String toTypeName(Class type) {
        if (type.isArray()) {
            return PlasticUtils.toTypeName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    public static String[] toTypeNames(Class[] types) {
        String[] result = new String[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PlasticUtils.toTypeName(types[i]);
        }
        return result;
    }

    public static Class toWrapperType(Class type) {
        assert (type != null);
        return type.isPrimitive() ? PrimitiveType.getByPrimitiveType((Class)type).wrapperType : type;
    }

    public static Method getMethod(Class declaringClass, String name, Class ... parameterTypes) {
        try {
            return declaringClass.getMethod(name, parameterTypes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static MethodDescription getMethodDescription(Class declaringClass, String name, Class ... parameterTypes) {
        return new MethodDescription(PlasticUtils.getMethod(declaringClass, name, parameterTypes));
    }

    public static boolean isPrimitive(String typeName) {
        return PrimitiveType.getByName(typeName) != null;
    }

    public static String getEnclosingClassName(String className) {
        int index = className.indexOf(36);
        return index <= 0 ? className : className.substring(0, index);
    }

    public static FieldInfo toFieldInfo(PlasticField field) {
        return new FieldInfo(field.getName(), field.getTypeName());
    }

    public static void implementFieldValueProvider(PlasticClass plasticClass, Set<FieldInfo> fieldInfos) {
        Set<PlasticMethod> methods = plasticClass.introduceInterface(FieldValueProvider.class);
        if (!methods.isEmpty()) {
            PlasticMethod method = methods.iterator().next();
            method.changeImplementation(builder -> {
                for (FieldInfo field : fieldInfos) {
                    builder.loadArgument(0);
                    builder.loadConstant(field.name);
                    builder.invokeVirtual(String.class.getName(), "boolean", "equals", Object.class.getName());
                    builder.when(Condition.NON_ZERO, ifBuilder -> {
                        ifBuilder.loadThis();
                        ifBuilder.getField(plasticClass.getClassName(), field.name, field.type);
                        ifBuilder.boxPrimitive(field.type);
                        ifBuilder.returnResult();
                    });
                }
                builder.loadThis();
                builder.instanceOf(FieldValueProvider.class);
                builder.when(Condition.NON_ZERO, ifBuilder -> {
                    builder.loadThis();
                    builder.loadArgument(0);
                    ifBuilder.invokeSpecial(plasticClass.getSuperClassName(), FIELD_VALUE_PROVIDER_METHOD_DESCRIPTION);
                    ifBuilder.returnResult();
                });
                builder.throwException(RuntimeException.class, "Field not found or not supported");
            });
        }
    }

    public static void implementPropertyValueProvider(PlasticClass plasticClass, Set<FieldInfo> fieldInfos) {
        PlasticMethod setterMethod;
        PlasticMethod getterMethod;
        Set<PlasticMethod> methods = plasticClass.introduceInterface(PropertyValueProvider.class);
        InstructionBuilderCallback getterCallback = builder -> {
            for (FieldInfo field : fieldInfos) {
                builder.loadArgument(0);
                builder.loadConstant(field.name);
                builder.invokeVirtual(String.class.getName(), "boolean", "equals", Object.class.getName());
                builder.when(Condition.NON_ZERO, ifBuilder -> {
                    String prefix = field.type.equals("boolean") ? "is" : "get";
                    String methodName = prefix + PlasticInternalUtils.capitalize(field.name);
                    ifBuilder.loadThis();
                    builder.invokeVirtual(plasticClass.getClassName(), field.type, methodName, new String[0]);
                    ifBuilder.boxPrimitive(field.type);
                    ifBuilder.returnResult();
                });
            }
            builder.loadThis();
            builder.instanceOf(PropertyValueProvider.class);
            builder.when(Condition.NON_ZERO, ifBuilder -> {
                builder.loadThis();
                builder.loadArgument(0);
                ifBuilder.invokeSpecial(plasticClass.getSuperClassName(), PROPERTY_VALUE_PROVIDER_GETTER_METHOD_DESCRIPTION);
                ifBuilder.returnResult();
            });
            builder.throwException(RuntimeException.class, "Property not found or not supported");
        };
        InstructionBuilderCallback setterCallback = builder -> {
            for (FieldInfo field : fieldInfos) {
                builder.loadArgument(0);
                builder.loadConstant(field.name);
                builder.invokeVirtual(String.class.getName(), "boolean", "equals", Object.class.getName());
                builder.when(Condition.NON_ZERO, ifBuilder -> {
                    String methodName = "set" + PlasticInternalUtils.capitalize(field.name);
                    ifBuilder.loadThis();
                    ifBuilder.loadArgument(1);
                    ifBuilder.castOrUnbox(field.type);
                    ifBuilder.invokeVirtual(plasticClass.getClassName(), Void.TYPE.getName(), methodName, field.type);
                    ifBuilder.returnResult();
                });
            }
            builder.loadThis();
            builder.instanceOf(PropertyValueProvider.class);
            builder.when(Condition.NON_ZERO, ifBuilder -> {
                builder.loadThis();
                builder.loadArgument(0);
                builder.loadArgument(1);
                ifBuilder.invokeSpecial(plasticClass.getSuperClassName(), PROPERTY_VALUE_PROVIDER_SETTER_METHOD_DESCRIPTION);
                ifBuilder.returnResult();
            });
            builder.throwException(RuntimeException.class, "Property not found or not supported");
        };
        if (methods.isEmpty()) {
            getterMethod = plasticClass.introduceMethod(PROPERTY_VALUE_PROVIDER_GETTER_METHOD_DESCRIPTION, getterCallback);
            setterMethod = plasticClass.introduceMethod(PROPERTY_VALUE_PROVIDER_SETTER_METHOD_DESCRIPTION, setterCallback);
        } else {
            getterMethod = methods.stream().filter(m -> m.getDescription().methodName.equals(GETTER_METHOD_NAME)).findFirst().get();
            setterMethod = methods.stream().filter(m -> m.getDescription().methodName.equals(SETTER_METHOD_NAME)).findFirst().get();
        }
        getterMethod.changeImplementation(getterCallback);
        setterMethod.changeImplementation(setterCallback);
    }

    static {
        try {
            PROPERTY_VALUE_PROVIDER_GETTER_METHOD_DESCRIPTION = new MethodDescription(PropertyValueProvider.class.getMethod(GETTER_METHOD_NAME, String.class));
            PROPERTY_VALUE_PROVIDER_SETTER_METHOD_DESCRIPTION = new MethodDescription(PropertyValueProvider.class.getMethod(SETTER_METHOD_NAME, String.class, Object.class));
            FIELD_VALUE_PROVIDER_METHOD_DESCRIPTION = new MethodDescription(FieldValueProvider.class.getMethod("__fieldValueProvider__get", String.class));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class FieldInfo {
        private final String name;
        private final String type;

        public FieldInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FieldInfo)) {
                return false;
            }
            FieldInfo other = (FieldInfo)obj;
            return Objects.equals(this.name, other.name);
        }

        public String toString() {
            return "FieldInfo [name=" + this.name + ", type=" + this.type + "]";
        }
    }
}

