/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.BufferFactory;
import org.apache.tinkerpop.gremlin.util.ser.NettyBuffer;

public class NettyBufferFactory
implements BufferFactory<ByteBuf> {
    public Buffer create(ByteBuf value) {
        return new NettyBuffer(value);
    }

    public Buffer wrap(ByteBuffer value) {
        return this.create(Unpooled.wrappedBuffer((ByteBuffer)value));
    }

    private static ByteBuf getFromIndex(Buffer buffer, int index) {
        if (buffer.nioBufferCount() == 1) {
            return Unpooled.wrappedBuffer((ByteBuffer)buffer.nioBuffer(index, buffer.capacity() - index));
        }
        return Unpooled.wrappedBuffer((ByteBuffer[])buffer.nioBuffers(index, buffer.capacity() - index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRaw(Buffer buffer, Consumer<ByteBuf> consumer) {
        if (buffer instanceof NettyBuffer) {
            consumer.accept(((NettyBuffer)buffer).getUnderlyingBuffer());
            return;
        }
        int initialIndex = buffer.readerIndex();
        ByteBuf newBuffer = NettyBufferFactory.getFromIndex(buffer, initialIndex);
        try {
            consumer.accept(newBuffer);
            buffer.readerIndex(initialIndex + newBuffer.readerIndex());
        }
        finally {
            newBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRaw(Buffer buffer, Consumer<ByteBuf> consumer) {
        if (buffer instanceof NettyBuffer) {
            consumer.accept(((NettyBuffer)buffer).getUnderlyingBuffer());
            return;
        }
        int initialIndex = buffer.writerIndex();
        ByteBuf newBuffer = NettyBufferFactory.getFromIndex(buffer, initialIndex);
        newBuffer.writerIndex(0);
        try {
            consumer.accept(newBuffer);
            buffer.writerIndex(initialIndex + newBuffer.writerIndex());
        }
        finally {
            newBuffer.release();
        }
    }
}

